/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.util;

import java.util.ArrayList;
import java.util.List;

public class MultiValueEncode {
    public static final String DELIMITER_STRING = ";";
    public static final char DELIMITER_CHAR = ';';
    public static final char ESCAPE_CHAR = '%';

    public static void main(String[] args) {
        String test1 = "run;test";
        String encode1 = MultiValueEncode.encodeValue(test1);
        System.out.println(encode1);
        String decode1 = MultiValueEncode.decodeValue(encode1);
        System.out.println(decode1);
        String test2 = "run;";
        String encode2 = MultiValueEncode.encodeValue(test2);
        System.out.println(encode2);
        String decode2 = MultiValueEncode.decodeValue(encode2);
        System.out.println(decode2);
        String test3 = ";run;";
        String encode3 = MultiValueEncode.encodeValue(test3);
        System.out.println(encode3);
        String decode3 = MultiValueEncode.decodeValue(encode3);
        System.out.println(decode3);
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add("run;test");
        valueList.add("debug");
        valueList.add("validate");
        valueList.add("verify");
        String valueString = MultiValueEncode.makeMultiValueString(valueList);
        System.out.println(valueString);
        List<String> decodeList = MultiValueEncode.decodeMultiValueString(valueString);
        System.out.println(decodeList);
    }

    public static String encodeValue(String input) {
        if (input.indexOf(59) < 0 && input.indexOf(37) < 0) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        block4: for (char c : input.toCharArray()) {
            switch (c) {
                case ';': {
                    sb.append("%37");
                    continue block4;
                }
                case '%': {
                    sb.append("%25");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String decodeValue(String input) {
        if (input.indexOf(37) < 0) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        block3: for (i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '%': {
                    if (i < input.length() - 2) {
                        String test = input.substring(i, i + 3);
                        if (test.equals("%37")) {
                            sb.append(';');
                            i += 2;
                            continue block3;
                        }
                        if (test.equals("%25")) {
                            sb.append('%');
                            i += 4;
                            continue block3;
                        }
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String makeMultiValueString(List<String> valueList) {
        StringBuilder sb = new StringBuilder();
        for (String nextValue : valueList) {
            if (sb.length() > 0) {
                sb.append(DELIMITER_STRING);
            }
            sb.append(MultiValueEncode.encodeValue(nextValue));
        }
        return sb.toString();
    }

    public static List<String> decodeMultiValueString(String input) {
        String[] valueArray;
        ArrayList<String> result = new ArrayList<String>();
        for (String nextValue : valueArray = input.split(DELIMITER_STRING)) {
            result.add(MultiValueEncode.decodeValue(nextValue));
        }
        return result;
    }
}

