/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.util;

import com.sas.svcs.common.client.ContentFilterCriteria;
import com.sas.svcs.common.client.ContentMatchType;
import com.sas.svcs.common.client.FolderContentFilterCriteria;
import com.sas.svcs.content.framework.client.ContentObjectDescriptor;
import com.sas.svcs.content.search.client.InvalidQueryException;
import com.sas.svcs.content.search.client.SearchService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public class ContentSearchUtil {
    private Set<SearchCategory> searchCategories;
    private boolean acceptEmptyFilters = true;
    private static SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.ENGLISH);

    public ContentSearchUtil() {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
    }

    private void addSearchCategory(SearchCategory category) {
        if (this.searchCategories == null) {
            this.searchCategories = new HashSet<SearchCategory>(5);
        }
        this.searchCategories.add(category);
    }

    public List<SearchCategory> getSearchCategories() {
        return this.searchCategories == null ? Collections.emptyList() : new ArrayList<SearchCategory>(this.searchCategories);
    }

    public void setAcceptEmptyFilters(boolean accept) {
        this.acceptEmptyFilters = accept;
    }

    public List<ContentObjectDescriptor> search(ContentFilterCriteria filter, SearchService searchService) throws InvalidQueryException {
        String query = this.generateQuery(filter);
        if (query == null) {
            return Collections.emptyList();
        }
        return searchService.search(query);
    }

    public String generateQuery(ContentFilterCriteria filter) {
        List keywords;
        String userName;
        boolean filterSet = false;
        boolean previousComponentExists = false;
        StringBuilder sb = new StringBuilder();
        sb.append("select * from Metadata where ");
        List types = filter.getTypes();
        if (types != null && !types.isEmpty()) {
            this.addSearchCategory(SearchCategory.TYPE);
            filterSet = true;
            previousComponentExists = true;
            int counter = 0;
            sb.append("(");
            for (String type : types) {
                if (counter > 0) {
                    sb.append(" OR ");
                }
                sb.append("type = '").append(type).append("'");
                ++counter;
            }
            sb.append(")");
        } else if (!filter.isIncludeUnknownTypes()) {
            previousComponentExists = true;
            sb.append("(type <> '')");
        }
        String name = filter.getName();
        if (name != null && !name.isEmpty()) {
            if (previousComponentExists) {
                sb.append(" AND ");
            }
            this.addSearchCategory(SearchCategory.NAME);
            previousComponentExists = true;
            filterSet = true;
            sb.append("(Name ");
            ContentMatchType match = filter.getNameTypeMatch();
            if (match == null) {
                match = ContentMatchType.MATCH_CONTAINS;
            }
            switch (match) {
                case MATCH_CONTAINS: {
                    sb.append("LIKE '%").append(this.normalizeValue(name)).append("%'");
                    break;
                }
                case MATCH_EQUALS: {
                    sb.append("= '").append(this.normalizeValue(name)).append("'");
                    break;
                }
                case MATCH_STARTSWITH: {
                    sb.append("LIKE '").append(this.normalizeValue(name)).append("%'");
                }
            }
            if (filter.isIncludeDescription()) {
                sb.append(" OR Description LIKE '%").append(this.normalizeValue(name)).append("%'");
            }
            sb.append(")");
        }
        Date since = filter.getSince();
        Date before = filter.getBefore();
        if (since != null || before != null) {
            String date1 = null;
            String date2 = null;
            try {
                date1 = this.formatDate(since);
                date2 = this.formatDate(before);
                if (previousComponentExists) {
                    sb.append(" AND ");
                }
                this.addSearchCategory(SearchCategory.DATE);
                previousComponentExists = true;
                filterSet = true;
                sb.append("(");
                if (date1 != null) {
                    sb.append(filter.isUseModifiedDate() ? "modifiedDate" : "creationDate").append(" > '").append(date1).append("'");
                }
                if (date2 != null) {
                    if (date1 != null) {
                        sb.append(" AND ");
                    }
                    sb.append(filter.isUseModifiedDate() ? "modifiedDate" : "creationDate").append(" < '").append(date2).append("'");
                }
                sb.append(")");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((userName = filter.getResponsibilityUser()) != null && !userName.isEmpty()) {
            if (previousComponentExists) {
                sb.append(" AND ");
            }
            this.addSearchCategory(SearchCategory.RESPONSIBILITY);
            previousComponentExists = true;
            filterSet = true;
            sb.append("(Responsibility='").append(this.normalizeValue(userName)).append("'");
            String role = filter.getResponsibilityRole();
            if (role != null && !role.isEmpty()) {
                sb.append(" AND ResponsibilityRole='").append(this.normalizeValue(role)).append("'");
            }
            sb.append(")");
        }
        if ((keywords = filter.getKeywords()) != null && !keywords.isEmpty()) {
            if (previousComponentExists) {
                sb.append(" AND ");
            }
            this.addSearchCategory(SearchCategory.KEYWORD);
            previousComponentExists = true;
            filterSet = true;
            int counter = 0;
            sb.append("(");
            for (String keyword : keywords) {
                if (counter > 0) {
                    sb.append(" OR ");
                }
                sb.append("Keyword = '").append(this.normalizeValue(keyword)).append("'");
                ++counter;
            }
            sb.append(")");
        }
        if (filter instanceof FolderContentFilterCriteria) {
            String folder = ((FolderContentFilterCriteria)filter).getFolder();
            boolean searchSubfolders = ((FolderContentFilterCriteria)filter).isSearchingSubfolders();
            if (folder != null && !folder.isEmpty()) {
                if (previousComponentExists) {
                    sb.append(" AND ");
                }
                this.addSearchCategory(SearchCategory.FOLDER);
                previousComponentExists = true;
                filterSet = true;
                if (searchSubfolders) {
                    sb.append("isdescendantnode('").append(this.normalizeValue(folder)).append("')");
                } else {
                    sb.append("ischildnode('").append(this.normalizeValue(folder)).append("')");
                }
            }
        }
        if (!filterSet && !this.acceptEmptyFilters) {
            return null;
        }
        return sb.toString();
    }

    private String formatDate(Date date) throws ParseException {
        if (date == null) {
            return null;
        }
        return sdf.format(date);
    }

    private String normalizeValue(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(value.length());
        int len = value.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("''");
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static enum SearchCategory {
        NAME,
        TYPE,
        DATE,
        KEYWORD,
        RESPONSIBILITY,
        FOLDER;

    }
}

