/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.namepath;

import com.sas.svcs.content.search.client.IllegalNameException;
import com.sas.svcs.content.search.client.namepath.MalformedPathException;
import com.sas.svcs.content.search.client.namepath.NameResolver;
import com.sas.svcs.content.search.client.namepath.NamespaceException;
import com.sas.svcs.content.search.client.namepath.Path;
import com.sas.svcs.content.search.client.namepath.PathFactory;
import com.sas.svcs.content.search.client.namepath.PathParser;
import com.sas.svcs.content.search.client.namepath.PathResolver;

public class ParsingPathResolver
implements PathResolver {
    private final PathFactory pathFactory;
    private final NameResolver resolver;

    public ParsingPathResolver(PathFactory pathFactory, NameResolver resolver) {
        this.pathFactory = pathFactory;
        this.resolver = resolver;
    }

    @Override
    public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
        return PathParser.parse(path, this.resolver, this.pathFactory);
    }

    @Override
    public String getJCRPath(Path path) throws NamespaceException {
        StringBuffer buffer = new StringBuffer();
        Path.Element[] elements = path.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buffer.append('/');
            }
            if (i == 0 && elements.length == 1 && elements[i].denotesRoot()) {
                buffer.append('/');
                continue;
            }
            if (elements[i].denotesCurrent()) {
                buffer.append('.');
                continue;
            }
            if (elements[i].denotesParent()) {
                buffer.append("..");
                continue;
            }
            buffer.append(this.resolver.getJCRName(elements[i].getName()));
            if (elements[i].getIndex() <= 1) continue;
            buffer.append('[');
            buffer.append(elements[i].getIndex());
            buffer.append(']');
        }
        return buffer.toString();
    }
}

