/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.namepath;

import com.sas.svcs.content.search.client.IllegalNameException;
import com.sas.svcs.content.search.client.namepath.NameException;
import com.sas.svcs.content.search.client.namepath.NameFactory;
import com.sas.svcs.content.search.client.namepath.NamespaceException;
import com.sas.svcs.content.search.client.namepath.NamespaceResolver;
import com.sas.svcs.content.search.client.namepath.XMLChar;
import javax.xml.namespace.QName;

public class NameParser {
    private static final int STATE_PREFIX_START = 0;
    private static final int STATE_PREFIX = 1;
    private static final int STATE_NAME_START = 2;
    private static final int STATE_NAME = 3;

    public static QName parse(String jcrName, NamespaceResolver resolver, NameFactory factory) throws IllegalNameException, NamespaceException {
        int len;
        int n = len = jcrName == null ? 0 : jcrName.length();
        if (len == 0) {
            throw new IllegalNameException("empty name");
        }
        if (".".equals(jcrName) || "..".equals(jcrName)) {
            throw new IllegalNameException(jcrName);
        }
        String prefix = "";
        int nameStart = 0;
        int state = 0;
        boolean trailingSpaces = false;
        for (int i = 0; i < len; ++i) {
            char c = jcrName.charAt(i);
            if (c == ':') {
                if (state == 0) {
                    throw new IllegalNameException("Prefix must not be empty");
                }
                if (state == 1) {
                    if (trailingSpaces) {
                        throw new IllegalNameException("Trailing spaces not allowed");
                    }
                    prefix = jcrName.substring(0, i);
                    if (!XMLChar.isValidNCName(prefix)) {
                        throw new IllegalNameException("Invalid name prefix: " + prefix);
                    }
                } else {
                    throw new IllegalNameException("'" + c + "' not allowed in name");
                }
                state = 2;
                trailingSpaces = false;
                continue;
            }
            if (c == ' ') {
                if (state == 0 || state == 2) {
                    throw new IllegalNameException("'" + c + "' not valid name start");
                }
                trailingSpaces = true;
                continue;
            }
            if (Character.isWhitespace(c) || c == '/' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"') {
                throw new IllegalNameException("'" + c + "' not allowed in name");
            }
            if (state == 0) {
                state = 1;
            } else if (state == 2) {
                state = 3;
                nameStart = i;
            }
            trailingSpaces = false;
        }
        if (nameStart == len || state == 2) {
            throw new IllegalNameException("Local name must not be empty");
        }
        if (trailingSpaces) {
            throw new IllegalNameException("Trailing spaces not allowed");
        }
        if (resolver == null) {
            return null;
        }
        String uri = resolver.getURI(prefix);
        return factory.create(uri, nameStart == 0 ? jcrName : jcrName.substring(nameStart, len));
    }

    public static QName[] parse(String[] jcrNames, NamespaceResolver resolver, NameFactory factory) throws NameException, NamespaceException {
        QName[] ret = new QName[jcrNames.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = NameParser.parse(jcrNames[i], resolver, factory);
        }
        return ret;
    }

    public static void checkFormat(String jcrName) throws IllegalNameException {
        try {
            NameParser.parse(jcrName, null, null);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }
}

