/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.logging.client;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LogItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LOGITEM_TYPE_HEADING = 0;
    public static final int LOGITEM_TYPE_BODY = 1;
    public static final int LOGITEM_TYPE_FOOTNOTE = 2;
    public static final int LOGITEM_PRIORITY_FATAL = 0;
    public static final int LOGITEM_PRIORITY_ERROR = 100;
    public static final int LOGITEM_PRIORITY_WARN = 200;
    public static final int LOGITEM_PRIORITY_INFO = 400;
    public static final int LOGITEM_PRIORITY_DEBUG = 500;
    public static final int LOGITEM_PRIORITY_ALL = 1000;
    private String id;
    private int priority;
    private Map<String, String> properties;
    private String classifier;
    private String text;
    private Date date;
    private static final int MODE_KEY = 0;
    private static final int MODE_VALUE = 1;

    private LogItem() {
    }

    public LogItem(String id) {
        this.id = id;
        this.date = new Date();
    }

    public LogItem(String id, int priority, String text) {
        this(id);
        this.priority = priority;
        this.text = text;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final Map<String, String> getProperties() {
        return this.properties;
    }

    public final void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public final String getPropertyString() {
        if (this.properties == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> entrySet = this.properties.entrySet();
        for (Map.Entry<String, String> nextEntry : entrySet) {
            sb.append('[');
            sb.append(this.escapeString(nextEntry.getKey(), 0));
            sb.append('=');
            sb.append(this.escapeString(nextEntry.getValue(), 1));
            sb.append(']');
        }
        return sb.toString();
    }

    public final void setPropertyString(String propertyString) {
        if (propertyString == null || propertyString.trim().length() == 0) {
            this.properties = null;
        }
        this.properties = this.parsePropertyString(propertyString);
    }

    public final String getClassifier() {
        return this.classifier;
    }

    public final void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String text) {
        this.text = text;
    }

    public final void setText(String text, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        t.printStackTrace(writer);
        this.text = text + "\n" + sw.toString();
    }

    public final Date getDate() {
        return this.date;
    }

    public final void setDate(Date date) {
        this.date = date;
    }

    private String escapeString(String inString, int mode) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        for (char nextChar : chars = inString.toCharArray()) {
            if (mode == 0 && nextChar == '=') {
                sb.append('\\');
            }
            if (mode == 1 && nextChar == ']') {
                sb.append('\\');
            }
            if (nextChar == '\\') {
                sb.append('\\');
            }
            sb.append(nextChar);
        }
        return sb.toString();
    }

    private String normalizeString(String inString) {
        StringBuilder sb = new StringBuilder();
        char[] chars = inString.toCharArray();
        int i = 0;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\') {
                ++i;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    private Map<String, String> parsePropertyString(String propertyString) {
        int start;
        HashMap<String, String> result = new HashMap<String, String>();
        int index = 0;
        int end = 0;
        int equals = 0;
        while (index < propertyString.length() && (start = propertyString.indexOf(91, index)) != -1) {
            for (int i = start; i < propertyString.length(); ++i) {
                if (propertyString.charAt(i) == '\\') {
                    i += 2;
                }
                if (propertyString.charAt(i) == '=') {
                    equals = i;
                }
                if (propertyString.charAt(i) != ']') continue;
                end = i;
                break;
            }
            String pairString = propertyString.substring(start + 1, end);
            String keyString = propertyString.substring(start + 1, equals);
            String valueString = propertyString.substring(equals + 1, end);
            result.put(this.normalizeString(keyString), this.normalizeString(valueString));
            index = end;
        }
        return result;
    }
}

