/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.logging.client;

import com.sas.services.util.XMLUtil;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.logging.client.ContentLog;
import com.sas.svcs.content.logging.client.ContentLoggingService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentLogCounter {
    private int debugCount = 0;
    private int infoCount = 0;
    private int warningCount = 0;
    private int errorCount = 0;
    private int fatalCount = 0;
    private String contentLogId;
    private ContentLoggingService service;
    private int priority = 400;

    public ContentLogCounter(ContentLoggingService service, String contentLogId) {
        this.service = service;
        this.contentLogId = contentLogId;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getDebugCount() {
        return this.debugCount;
    }

    public int getInfoCount() {
        return this.infoCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFatalCount() {
        return this.fatalCount;
    }

    public void initialize() throws ObjectNotFoundException, SAXException {
        ContentLog log = this.service.getContentLog(this.contentLogId);
        String contents = this.service.readContentLog(log, this.priority);
        XMLUtil.parseXML((String)contents, (DefaultHandler)new ContentLogParser());
    }

    private class ContentLogParser
    extends DefaultHandler {
        private ContentLogParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String priority;
            if (qName.equalsIgnoreCase("LogItem") && (priority = attributes.getValue("Priority")) != null) {
                int value = Integer.valueOf(priority);
                switch (value) {
                    case 500: {
                        ContentLogCounter.this.debugCount++;
                        break;
                    }
                    case 400: {
                        ContentLogCounter.this.infoCount++;
                        break;
                    }
                    case 200: {
                        ContentLogCounter.this.warningCount++;
                        break;
                    }
                    case 100: {
                        ContentLogCounter.this.errorCount++;
                        break;
                    }
                    case 0: {
                        ContentLogCounter.this.fatalCount++;
                        break;
                    }
                }
            }
        }
    }
}

