/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.client;

import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.authorization.client.AuthorizationService;
import com.sas.svcs.content.authorization.client.EffectivePermissions;
import com.sas.svcs.content.client.util.FolderTypeUtil;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TransportState;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.navigation.client.NavigationNode;
import com.sas.svcs.content.navigation.client.NavigationService;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIDescriptor;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIService;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportUtil {
    private static final Logger log = LogManager.getLogger(TransportUtil.class);

    public static String getDisplayType(String objectTypeName, ObjectTypeUIService typeService) {
        Locale locale = Locale.getDefault();
        return TransportUtil.getDisplayType(objectTypeName, locale, typeService);
    }

    public static String getDisplayType(String objectTypeName, Locale locale, ObjectTypeUIService typeService) {
        String displayName = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (typeService != null) {
            try {
                Properties localizedNames;
                ObjectTypeUIDescriptor descriptor = typeService.getObjectTypeDescriptorByName(objectTypeName);
                if (descriptor != null && (localizedNames = descriptor.getLocalizedNames()) != null) {
                    displayName = localizedNames.getProperty(locale.toString());
                }
            }
            catch (Exception e) {
                log.warn("Unable to retrieve localized type value for " + objectTypeName, (Throwable)e);
            }
        }
        return displayName == null ? objectTypeName : displayName;
    }

    public static boolean isObjectStateSet(TargetTransportNode node, int stateValue) {
        TransportState state = node.getTransportState();
        return state.isStateSet(stateValue);
    }

    public static boolean isDisabled(TargetTransportNode node) {
        return TransportUtil.isObjectStateSet(node, 1);
    }

    public static boolean isCreating(TargetTransportNode node) {
        return TransportUtil.isObjectStateSet(node, 2);
    }

    public static boolean isOverwriting(TargetTransportNode node) {
        return TransportUtil.isObjectStateSet(node, 4);
    }

    public static boolean isPermissionGranted(TargetTransportNode node) {
        return !TransportUtil.isReadPermissionDenied(node) && !TransportUtil.isWritePermissionDenied(node);
    }

    public static boolean isReadPermissionDenied(TargetTransportNode node) {
        return TransportUtil.isObjectStateSet(node, 128);
    }

    public static boolean isWritePermissionDenied(TargetTransportNode node) {
        return TransportUtil.isObjectStateSet(node, 80);
    }

    public static boolean isWritePermissionDeniedOnParent(TargetTransportNode node) {
        return TransportUtil.isObjectStateSet(node, 64);
    }

    public static boolean canNodeBeTransported(TargetTransportNode node) {
        return TransportUtil.isValid(node) && TransportUtil.isPermissionGranted(node);
    }

    public static boolean isValid(TargetTransportNode node) {
        return !TransportUtil.isObjectStateSet(node, 3840);
    }

    public static boolean isTransportableFolderType(long objectType) {
        return FolderTypeUtil.isFolderType((long)objectType) || objectType == 30L;
    }

    public static boolean isTransportAllowedOnContainer(NavigationService navService, AuthorizationService authService, ContainerNode container) throws ObjectNotFoundException {
        if (container == null) {
            return true;
        }
        long objectType = container.getObjectType();
        boolean authorized = false;
        if (FolderTypeUtil.isFolderType((long)objectType)) {
            ObjectIdentity identity = ObjectIdentityUtils.createObjectIdentity((Identifiable)container);
            authorized = TransportUtil.isFolderWriteAuthorized(authService, identity);
        } else if (TransportUtil.isVirtualFolder(objectType)) {
            ObjectIdentity parentId = container.getParentId();
            while (parentId != null) {
                NavigationNode node;
                if (FolderTypeUtil.isFolderType((long)parentId.getObjectType())) {
                    authorized = TransportUtil.isFolderWriteAuthorized(authService, parentId);
                    break;
                }
                if (!TransportUtil.isVirtualFolder(parentId.getObjectType()) || (node = navService.getObjectById(parentId)) == null) continue;
                parentId = node.getParentId();
            }
        } else {
            ObjectIdentity identity = ObjectIdentityUtils.createObjectIdentity((Identifiable)container);
            authorized = TransportUtil.isObjectWriteAuthorized(authService, identity);
        }
        return authorized;
    }

    public static void validateTargetContainerPermissions(NavigationService navService, AuthorizationService authService, ContainerNode container) throws ObjectNotFoundException, ContentException {
        if (container == null) {
            return;
        }
        long objectType = container.getObjectType();
        boolean authorized = false;
        if (FolderTypeUtil.isFolderType((long)objectType)) {
            ObjectIdentity identity = ObjectIdentityUtils.createObjectIdentity((Identifiable)container);
            authorized = TransportUtil.isFolderWriteAuthorized(authService, identity);
        } else if (TransportUtil.isVirtualFolder(objectType)) {
            ObjectIdentity parentId = container.getParentId();
            while (parentId != null) {
                NavigationNode node;
                if (FolderTypeUtil.isFolderType((long)parentId.getObjectType())) {
                    authorized = TransportUtil.isFolderWriteAuthorized(authService, parentId);
                    break;
                }
                if (!TransportUtil.isVirtualFolder(parentId.getObjectType()) || (node = navService.getObjectById(parentId)) == null) continue;
                parentId = node.getParentId();
            }
        } else {
            ObjectIdentity identity = ObjectIdentityUtils.createObjectIdentity((Identifiable)container);
            authorized = TransportUtil.isObjectWriteAuthorized(authService, identity);
        }
        if (!authorized) {
            throw new RuntimeException("You are not authorized to perform this action");
        }
    }

    private static boolean isObjectWriteAuthorized(AuthorizationService authService, ObjectIdentity identity) throws ObjectNotFoundException {
        EffectivePermissions permissions = authService.getEffectivePermissions(identity);
        return permissions != null && permissions.isWriteAllowed();
    }

    private static boolean isFolderWriteAuthorized(AuthorizationService authService, ObjectIdentity identity) throws ObjectNotFoundException {
        EffectivePermissions permissions = authService.getEffectivePermissions(identity);
        return permissions != null && permissions.isAddAllowed();
    }

    private static boolean isVirtualFolder(long objectType) {
        return 30L == objectType;
    }
}

