/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.client;

import com.sas.svcs.content.lifecycle.client.OperationNode;
import com.sas.svcs.content.lifecycle.client.SelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ContentOperation<T extends OperationNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Object, Object> cache;
    private Locale locale = null;
    protected Map<String, T> operationNodeMap;
    protected SelectionModel<T> selectionModel;

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public T getOperationNode(String id) {
        return (T)(this.operationNodeMap == null ? null : (OperationNode)this.operationNodeMap.get(id));
    }

    public List<T> getOperationNodes() {
        if (this.operationNodeMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(this.operationNodeMap.values());
    }

    public void setOperationNodes(List<T> operationNodes) {
        this.operationNodeMap = new LinkedHashMap<String, T>();
        for (OperationNode node : operationNodes) {
            this.operationNodeMap.put(node.getId(), node);
        }
    }

    public void setSelectionModel(SelectionModel<T> selectionModel) {
        this.selectionModel = selectionModel;
    }

    public SelectionModel<T> getSelectionModel() {
        return this.selectionModel;
    }

    public void addObjectToCache(Object key, Object value) {
        if (this.cache == null) {
            this.cache = new HashMap<Object, Object>();
        }
        this.cache.put(key, value);
    }

    public Object getObjectFromCache(Object key) {
        return this.cache == null ? null : this.cache.get(key);
    }

    public void removeObjectFromCache(Object key) {
        if (this.cache != null) {
            this.cache.remove(key);
        }
    }
}

