/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.client;

import com.sas.svcs.content.lifecycle.client.Container;
import com.sas.svcs.content.lifecycle.client.OperationNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ContainerDelegate<T extends OperationNode>
implements Container<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> children;

    @Override
    public void setChildren(List<T> children) {
        this.children = children;
    }

    @Override
    public List<T> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    @Override
    public void addChild(T child) {
        if (this.children == null) {
            this.children = new ArrayList<T>();
        }
        this.children.add(child);
    }

    @Override
    public void addChild(T child, int index) {
        if (this.children == null) {
            this.children = new ArrayList<T>();
        }
        this.children.add(index, child);
    }

    @Override
    public void removeChild(T child) {
        if (this.children != null && this.children.contains(child)) {
            this.children.remove(child);
        }
    }

    public void selectChildren(boolean selected) {
        if (this.children != null) {
            for (OperationNode child : this.children) {
                child.setSelected(selected);
            }
        }
    }
}

