/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.om.Item;

public class VariableReferenceCompiler
extends SequenceExpressionCompiler {
    private static String globalVariableReference(CompilerService compiler, Binding binding) {
        if (compiler.isInServletMode()) {
            return "global" + binding.getLocalSlotNumber() + "(" + compiler.getContextVariableName() + ")";
        }
        return "global" + binding.getLocalSlotNumber();
    }

    public String compileToIterator(CompilerService compiler, Expression expr) {
        VariableReference exp = (VariableReference)expr;
        Binding binding = exp.getBinding();
        if (binding.isGlobal()) {
            String vblout = "v" + compiler.getUniqueNumber();
            compiler.emit("SequenceIterator " + vblout + " = Value.asIterator(" + VariableReferenceCompiler.globalVariableReference(compiler, binding) + ");");
            return vblout;
        }
        if (binding.getLocalSlotNumber() != -1) {
            String vblout = "v" + compiler.getUniqueNumber();
            compiler.emit("SequenceIterator " + vblout + " = Value.asIterator(" + compiler.getXPathVariableName(binding.getLocalSlotNumber()) + ");");
            return vblout;
        }
        throw new UnsupportedOperationException("Can't yet compile this kind of variable reference");
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        VariableReference exp = (VariableReference)expr;
        String vblout = "v" + compiler.getUniqueNumber();
        Binding binding = exp.getBinding();
        if (binding.isGlobal()) {
            String globalVar = VariableReferenceCompiler.globalVariableReference(compiler, binding);
            if (compiler.isInstance(globalVar, Item.class)) {
                return globalVar;
            }
            compiler.declare(Item.class, vblout, "Value.asItem(" + globalVar + ")", true);
            return vblout;
        }
        if (binding.getLocalSlotNumber() != -1) {
            String localVar = compiler.getXPathVariableName(binding.getLocalSlotNumber());
            if (compiler.isInstance(localVar, Item.class)) {
                return localVar;
            }
            compiler.declare(Item.class, vblout, "Value.asItem(" + localVar + ")", true);
            return vblout;
        }
        throw new UnsupportedOperationException("Can't yet compile this kind of variable reference");
    }

    public static String getJavaVariableName(CompilerService compiler, VariableReference ref) {
        if (ref.getBinding().isGlobal()) {
            return VariableReferenceCompiler.globalVariableReference(compiler, ref.getBinding());
        }
        return compiler.getXPathVariableName(ref.getBinding().getLocalSlotNumber());
    }
}

