/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.SingletonComparisonCompiler;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class ValueComparisonCompiler
extends ToBooleanCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        ValueComparison exp = (ValueComparison)expr;
        TypeHierarchy th = compiler.getTypeHierarchy();
        Expression[] operands = exp.getOperands();
        int n = compiler.getUniqueNumber();
        String resultVar = "vcomp" + n;
        BooleanValue resultWhenEmpty = exp.getResultWhenEmpty();
        int operator = exp.getOperator();
        String op0var = compiler.compileToItem(operands[0]);
        String op1var = compiler.compileToItem(operands[1]);
        if (exp.needsRuntimeComparabilityCheck()) {
            this.compileComparabilityCheck(compiler, exp, op0var, op1var);
        }
        boolean emptiable0 = Cardinality.allowsZero((int)operands[0].getCardinality());
        boolean emptiable1 = Cardinality.allowsZero((int)operands[1].getCardinality());
        ItemType t0 = operands[0].getItemType(th).getPrimitiveItemType();
        ItemType t1 = operands[1].getItemType(th).getPrimitiveItemType();
        String jexp = SingletonComparisonCompiler.compileComparison(exp.getAtomicComparer(), op0var, compiler, op1var, operator);
        jexp = ValueComparisonCompiler.adjustForNaN(compiler, t0, op0var, operator, jexp);
        jexp = ValueComparisonCompiler.adjustForNaN(compiler, t1, op1var, operator, jexp);
        jexp = "BooleanValue.get(" + jexp + ")";
        if (emptiable0 || emptiable1) {
            String condition;
            if (emptiable0) {
                condition = op0var + "==null";
                if (emptiable1) {
                    condition = condition + " || " + op1var + "==null";
                }
            } else {
                condition = op1var + "==null";
            }
            String resultWhenEmptyExp = "null";
            if (resultWhenEmpty == BooleanValue.TRUE) {
                resultWhenEmptyExp = "BooleanValue.TRUE";
            } else if (resultWhenEmpty == BooleanValue.FALSE) {
                resultWhenEmptyExp = "BooleanValue.FALSE";
            }
            jexp = "( " + condition + " ? " + resultWhenEmptyExp + " : " + jexp + " )";
        }
        compiler.declare(BooleanValue.class, resultVar, jexp, true);
        return resultVar;
    }

    protected static String adjustForNaN(CompilerService compiler, ItemType t, String var, int operator, String jexp) {
        boolean nanable;
        TypeHierarchy th = compiler.getTypeHierarchy();
        boolean bl = nanable = th.relationship(t, (ItemType)BuiltInAtomicType.DOUBLE) != 4 || th.relationship(t, (ItemType)BuiltInAtomicType.FLOAT) != 4;
        if (nanable) {
            var = compiler.cast(var, AtomicValue.class);
            jexp = operator == 51 ? var + ".isNaN() || " + jexp : "!" + var + ".isNaN() && " + jexp;
        }
        return jexp;
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        ValueComparison exp = (ValueComparison)expr;
        TypeHierarchy th = compiler.getTypeHierarchy();
        Expression[] operands = exp.getOperands();
        BooleanValue resultWhenEmpty = exp.getResultWhenEmpty();
        int operator = exp.getOperator();
        String op0var = compiler.compileToItem(operands[0]);
        String op1var = compiler.compileToItem(operands[1]);
        if (exp.needsRuntimeComparabilityCheck()) {
            this.compileComparabilityCheck(compiler, exp, op0var, op1var);
        }
        boolean emptiable0 = Cardinality.allowsZero((int)operands[0].getCardinality());
        boolean emptiable1 = Cardinality.allowsZero((int)operands[1].getCardinality());
        String jexp = SingletonComparisonCompiler.compileComparison(exp.getAtomicComparer(), op0var, compiler, op1var, operator);
        ItemType t0 = operands[0].getItemType(th).getPrimitiveItemType();
        ItemType t1 = operands[1].getItemType(th).getPrimitiveItemType();
        jexp = ValueComparisonCompiler.adjustForNaN(compiler, t0, op0var, operator, jexp);
        jexp = ValueComparisonCompiler.adjustForNaN(compiler, t1, op1var, operator, jexp);
        if (emptiable0 || emptiable1) {
            String condition;
            if (emptiable0) {
                condition = op0var + "==null";
                if (emptiable1) {
                    condition = condition + " || " + op1var + "==null";
                }
            } else {
                condition = op1var + "==null";
            }
            jexp = "( " + condition + " ? " + (resultWhenEmpty == BooleanValue.TRUE ? "true" : "false") + " : " + jexp + " )";
        }
        compiler.emit(result.output(compiler, jexp));
        return result.getVariableName();
    }

    private void compileComparabilityCheck(CompilerService compiler, ValueComparison exp, String op0var, String op1var) {
        Expression[] operands = exp.getOperands();
        boolean emptiable0 = Cardinality.allowsZero((int)operands[0].getCardinality());
        boolean emptiable1 = Cardinality.allowsZero((int)operands[1].getCardinality());
        boolean ordered = Token.isOrderedOperator((int)exp.getOperator());
        String guard = "";
        if (emptiable0) {
            guard = op0var + "!=null && ";
        }
        if (emptiable1) {
            guard = guard + op1var + "!=null && ";
        }
        TypeHierarchy th = compiler.getTypeHierarchy();
        int p0 = operands[0].getItemType(th).getPrimitiveType();
        int p1 = operands[1].getItemType(th).getPrimitiveType();
        op0var = compiler.cast(op0var, AtomicValue.class);
        op1var = compiler.cast(op1var, AtomicValue.class);
        String typeName0 = p0 == 632 ? "(BuiltInAtomicType)" + op0var + ".getItemType(th).getPrimitiveItemType()" : "(BuiltInAtomicType)BuiltInType.getSchemaType(" + p0 + ")";
        String typeName1 = p1 == 632 ? "(BuiltInAtomicType)" + op1var + ".getItemType(th).getPrimitiveItemType()" : "(BuiltInAtomicType)BuiltInType.getSchemaType(" + p1 + ")";
        String displayName0 = p0 == 632 ? "StandardNames.getDisplayName(" + op0var + ".getItemType(th).getPrimitiveType())" : CompilerService.javaEscape(StandardNames.getDisplayName((int)p0));
        String displayName1 = p1 == 632 ? "StandardNames.getDisplayName(" + op1var + ".getItemType(th).getPrimitiveType())" : CompilerService.javaEscape(StandardNames.getDisplayName((int)p1));
        compiler.emit("if (" + guard + "!Type.isComparable(" + typeName0 + ", " + typeName1 + ", " + ordered + ")) {");
        compiler.emit("dynamicError(\"Cannot compare \" + " + displayName0 + " + \" to \" + " + displayName1 + ", \"XPTY0004\", " + compiler.getContextVariableName() + ");");
        compiler.emit("}");
    }
}

