/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.PushExpressionCompiler;
import com.saxonica.codegen.SequenceExpressionCompiler;
import com.saxonica.deploy.CompiledClosure;
import com.saxonica.deploy.CompiledMemoClosure;
import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class UserFunctionCallCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        UserFunctionCall exp = (UserFunctionCall)expr;
        if (exp.isRecursiveTailCall()) {
            this.compileTailCall(compiler, exp);
            return null;
        }
        int n = compiler.getUniqueNumber();
        String resultVar = "result" + n;
        int mode = compiler.getFunctionEvaluationMode(exp.getFunction());
        switch (mode) {
            case 8: {
                String valVar = this.compileCall(compiler, exp, ValueRepresentation.class);
                compiler.declare(SequenceIterator.class, resultVar, "Value.asIterator(" + valVar + ")", true);
                return resultVar;
            }
            case 3: {
                return this.compileCall(compiler, exp, SequenceIterator.class);
            }
            case 7: {
                String itemVar = this.compileCall(compiler, exp, Item.class);
                compiler.declare(SequenceIterator.class, resultVar, "SingletonIterator.makeIterator(" + itemVar + ")", true);
                return resultVar;
            }
            case 9: {
                String outVar = PushExpressionCompiler.prepareToPush(n, compiler, null);
                this.compileCall(compiler, exp, null);
                compiler.popContextVariable();
                compiler.popOutputterVariable();
                compiler.emit(outVar + ".close();");
                compiler.declare(SequenceIterator.class, resultVar, outVar + ".iterate()", true);
                return resultVar;
            }
        }
        throw new IllegalArgumentException();
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        UserFunctionCall exp = (UserFunctionCall)expr;
        if (exp.isRecursiveTailCall()) {
            this.compileTailCall(compiler, exp);
            return null;
        }
        int mode = compiler.getFunctionEvaluationMode(exp.getFunction());
        if (mode == 7) {
            return this.compileCall(compiler, exp, Item.class);
        }
        return super.compileToItem(compiler, expr);
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        UserFunctionCall exp = (UserFunctionCall)expr;
        if (exp.isRecursiveTailCall()) {
            this.compileTailCall(compiler, exp);
            return;
        }
        int n = compiler.getUniqueNumber();
        String resultVar = "result" + n;
        int mode = compiler.getFunctionEvaluationMode(exp.getFunction());
        if (mode == 8) {
            String valVar = this.compileCall(compiler, exp, ValueRepresentation.class);
            compiler.declare(SequenceIterator.class, resultVar, "Value.asIterator(" + valVar + ")", true);
            compiler.emit("while (true) {");
            compiler.declare(Item.class, "item" + n, resultVar + ".next()", true);
            compiler.emit("if (item" + n + "== null) break;");
            compiler.emit(compiler.getOutputterVariableName() + ".append(item" + n + ", 0, NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        } else if (mode == 3) {
            String iterVar = this.compileCall(compiler, exp, SequenceIterator.class);
            String itemVar = "item" + n;
            compiler.emit("while (true) {");
            compiler.declare(Item.class, itemVar, iterVar + ".next()", true);
            compiler.emit("if (" + itemVar + "== null) break;");
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + itemVar + ", 0, NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        } else if (mode == 7) {
            String itemVar = this.compileCall(compiler, exp, Item.class);
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + itemVar + ", 0, NodeInfo.ALL_NAMESPACES);");
        } else if (mode == 9) {
            this.compileCall(compiler, exp, null);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String compileToValueRepresentation(CompilerService compiler, Expression expr) {
        UserFunctionCall exp = (UserFunctionCall)expr;
        if (exp.isRecursiveTailCall()) {
            this.compileTailCall(compiler, exp);
            return null;
        }
        int mode = compiler.getFunctionEvaluationMode(exp.getFunction());
        if (mode == 8) {
            return this.compileCall(compiler, exp, ValueRepresentation.class);
        }
        if (mode == 3) {
            int type = exp.getItemType(compiler.getTypeHierarchy()).getPrimitiveType();
            int card = exp.getCardinality();
            return "new CompiledMemoClosure(" + this.compileCall(compiler, exp, SequenceIterator.class) + ", " + type + ", " + card + ")";
        }
        if (mode == 7) {
            return this.compileToItem(compiler, (Expression)exp);
        }
        if (mode == 9) {
            return super.compileToValueRepresentation(compiler, (Expression)exp);
        }
        throw new IllegalArgumentException();
    }

    private String compileCall(CompilerService compiler, UserFunctionCall exp, Class resultClass) {
        int n = compiler.getUniqueNumber();
        String resultVar = "value" + n;
        UserFunction fn = exp.getFunction();
        String methodName = compiler.getMethodName(fn);
        Expression[] arguments = exp.getArguments();
        int[] argumentEvaluationModes = exp.getArgumentEvaluationModes();
        ArrayList<String> argumentNames = new ArrayList<String>();
        TypeHierarchy th = compiler.getTypeHierarchy();
        for (int a = 0; a < exp.getNumberOfArguments(); ++a) {
            int refs = fn.getParameterDefinitions()[a].getReferenceCount();
            int reqCardinality = fn.getParameterDefinitions()[a].getRequiredType().getCardinality();
            if (Cardinality.allowsMany((int)reqCardinality)) {
                int mode = argumentEvaluationModes[a];
                if (mode == 0 && arguments[a] instanceof Literal) {
                    mode = 6;
                }
                switch (mode) {
                    case 0: {
                        argumentNames.add("EmptySequence.getInstance()");
                        break;
                    }
                    case 1: {
                        if (refs > 1 && arguments[a] instanceof LocalVariableReference) {
                            String variableName = compiler.getXPathVariableName(((LocalVariableReference)arguments[a]).getSlotNumber());
                            if (compiler.isInstance(variableName, CompiledClosure.class) && !compiler.isInstance(variableName, CompiledMemoClosure.class)) {
                                argumentNames.add("new CompiledMemoClosure(" + variableName + ")");
                                break;
                            }
                            argumentNames.add(compiler.compileToValueRepresentation(arguments[a]));
                            break;
                        }
                        argumentNames.add(compiler.compileToValueRepresentation(arguments[a]));
                        break;
                    }
                    case 5: {
                        argumentNames.add("EmptySequence.getInstance()");
                        break;
                    }
                    case 3: {
                        String iterVar3 = compiler.compileToIterator(arguments[a]);
                        int primitiveType = arguments[a].getItemType(th).getPrimitiveType();
                        int cardinality = arguments[a].getCardinality();
                        argumentNames.add("new CompiledClosure(" + iterVar3 + "," + primitiveType + "," + cardinality + ")");
                        break;
                    }
                    case 4: 
                    case 13: {
                        String iterVar3 = compiler.compileToIterator(arguments[a]);
                        int primitiveType = arguments[a].getItemType(th).getPrimitiveType();
                        int cardinality = arguments[a].getCardinality();
                        argumentNames.add("new CompiledMemoClosure(" + iterVar3 + "," + primitiveType + "," + cardinality + ")");
                        break;
                    }
                    case -1: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: {
                        String iterVar3 = compiler.compileToIterator(arguments[a]);
                        argumentNames.add("SequenceExtent.makeSequenceExtent(" + iterVar3 + ")");
                        break;
                    }
                    case 7: {
                        String itemVar = compiler.compileToItem(arguments[a]);
                        argumentNames.add(itemVar);
                        break;
                    }
                    case 12: {
                        String iterVar = compiler.compileToIterator(arguments[a]);
                        argumentNames.add("new IndexedValue(" + iterVar + ")");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown expression evaluation mode " + argumentEvaluationModes[a]);
                    }
                }
                continue;
            }
            if (Cardinality.allowsZero((int)reqCardinality)) {
                String var = compiler.compileToItem(arguments[a]);
                String valueVar = "value" + n + "_" + a;
                compiler.declare(ValueRepresentation.class, valueVar, "(" + var + " == null ? EmptySequence.getInstance() : (ValueRepresentation)" + var + ")", true);
                argumentNames.add(valueVar);
                continue;
            }
            String var = compiler.compileToItem(arguments[a]);
            ItemType type = fn.getArgumentType(a).getPrimaryType();
            if (compiler.getTypeHierarchy().isSubType(type, (ItemType)AnyNodeTest.getInstance())) {
                argumentNames.add(compiler.cast(var, NodeInfo.class));
                continue;
            }
            if (compiler.getTypeHierarchy().isSubType(type, (ItemType)BuiltInAtomicType.ANY_ATOMIC)) {
                argumentNames.add(compiler.cast(var, AtomicValue.class));
                continue;
            }
            argumentNames.add(var);
        }
        FastStringBuffer sb = new FastStringBuffer(64);
        for (int a = 0; a < exp.getNumberOfArguments(); ++a) {
            sb.append((String)argumentNames.get(a));
            sb.append(", ");
        }
        compiler.emitComment("call " + exp.getDisplayName());
        if (resultClass == null) {
            compiler.emit(methodName + "(" + sb + compiler.getContextVariableName() + ");");
        } else {
            compiler.declare(resultClass, resultVar, methodName + "(" + sb + compiler.getContextVariableName() + ")", true);
        }
        return resultVar;
    }

    private String compileTailCall(CompilerService compiler, UserFunctionCall exp) {
        UserFunction fn = exp.getFunction();
        Expression[] arguments = exp.getArguments();
        int[] argumentEvaluationModes = exp.getArgumentEvaluationModes();
        TypeHierarchy th = compiler.getTypeHierarchy();
        for (int a = 0; a < exp.getNumberOfArguments(); ++a) {
            String var;
            String argName = compiler.getXPathVariableName(a);
            if (argName.endsWith("Final")) {
                argName = argName.substring(0, argName.length() - 5);
            }
            int refs = fn.getParameterDefinitions()[a].getReferenceCount();
            if (Cardinality.allowsMany((int)arguments[a].getCardinality())) {
                switch (argumentEvaluationModes[a]) {
                    case 0: {
                        compiler.assign(argName, "null");
                        break;
                    }
                    case 1: {
                        if (refs > 1 && arguments[a] instanceof LocalVariableReference) {
                            String variableName = compiler.getXPathVariableName(((LocalVariableReference)arguments[a]).getSlotNumber());
                            if (compiler.isInstance(variableName, CompiledClosure.class) && !compiler.isInstance(variableName, CompiledMemoClosure.class)) {
                                compiler.assign(argName, "new CompiledMemoClosure(" + variableName + ")");
                                break;
                            }
                            compiler.assign(argName, compiler.compileToValueRepresentation(arguments[a]));
                            break;
                        }
                        compiler.assign(argName, compiler.compileToValueRepresentation(arguments[a]));
                        break;
                    }
                    case 5: {
                        compiler.assign(argName, "EmptySequence.getInstance()");
                        break;
                    }
                    case 3: {
                        String iterVar3 = compiler.compileToIterator(arguments[a]);
                        int primitiveType = arguments[a].getItemType(th).getPrimitiveType();
                        int cardinality = arguments[a].getCardinality();
                        compiler.assign(argName, "new CompiledClosure(" + iterVar3 + "," + primitiveType + "," + cardinality + ")");
                        break;
                    }
                    case 4: 
                    case 13: {
                        String iterVar3 = compiler.compileToIterator(arguments[a]);
                        int primitiveType = arguments[a].getItemType(th).getPrimitiveType();
                        int cardinality = arguments[a].getCardinality();
                        compiler.assign(argName, "new CompiledMemoClosure(" + iterVar3 + "," + primitiveType + "," + cardinality + ")");
                        break;
                    }
                    case -1: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: {
                        String iterVar3 = compiler.compileToIterator(arguments[a]);
                        compiler.assign(argName, "SequenceExtent.makeSequenceExtent(" + iterVar3 + ")");
                        break;
                    }
                    case 7: {
                        String itemVar = compiler.compileToItem(arguments[a]);
                        compiler.assign(argName, itemVar);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown expression evaluation mode " + argumentEvaluationModes[a]);
                    }
                }
                continue;
            }
            if (Cardinality.allowsZero((int)arguments[a].getCardinality())) {
                var = compiler.compileToItem(arguments[a]);
                compiler.assign(argName, "(" + var + " == null ? EmptySequence.getInstance() : (ValueRepresentation)" + var + ")");
                continue;
            }
            var = compiler.compileToItem(arguments[a]);
            ItemType type = fn.getArgumentType(a).getPrimaryType();
            if (compiler.getTypeHierarchy().isSubType(type, (ItemType)AnyNodeTest.getInstance())) {
                compiler.assign(argName, compiler.cast(var, NodeInfo.class));
                continue;
            }
            if (compiler.getTypeHierarchy().isSubType(type, (ItemType)BuiltInAtomicType.ANY_ATOMIC)) {
                compiler.assign(argName, compiler.cast(var, AtomicValue.class));
                continue;
            }
            compiler.assign(argName, var);
        }
        compiler.assign("doTailCall", "true");
        compiler.emitComment("tail call " + exp.getDisplayName());
        return "null";
    }
}

