/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.UntypedAtomicConverter;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class UntypedAtomicConverterCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        UntypedAtomicConverter exp = (UntypedAtomicConverter)expr;
        String sequenceVar = compiler.compileToIterator(exp.getBaseExpression());
        String typeVar = compiler.compileItemType(exp.getRequiredItemType());
        boolean all = exp.areAllItemsConverted();
        int n = compiler.getUniqueNumber();
        String mf = "convertUntyped" + n;
        String resultVar = "s" + n;
        String contextVar = "fc" + n;
        compiler.emit("final XPathContext " + contextVar + " = " + compiler.getContextVariableName() + ";");
        compiler.emit("ItemMappingFunction " + mf + " = new ItemMappingFunction() { // convert untypedAtomic");
        compiler.emit("public Item mapItem(Item item) throws XPathException {");
        if (!all) {
            compiler.emit("if (item instanceof UntypedAtomicValue) {");
        }
        compiler.emit("return ((UntypedAtomicValue)item).convert(" + typeVar + ", " + contextVar + ");");
        if (!all) {
            compiler.emit("} else {");
            compiler.emit("return item;");
            compiler.emit("}");
        }
        compiler.emit("}");
        compiler.emit("};");
        compiler.emit("SequenceIterator " + resultVar + " = new EveryItemMappingIterator(" + sequenceVar + ", " + mf + ");");
        return resultVar;
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        UntypedAtomicConverter exp = (UntypedAtomicConverter)expr;
        String itemVar = compiler.compileToItem(exp.getBaseExpression());
        String castItemVar = compiler.cast(itemVar, AtomicValue.class);
        String typeVar = compiler.compileItemType(exp.getRequiredItemType());
        boolean all = exp.areAllItemsConverted();
        int n = compiler.getUniqueNumber();
        String outVar = "converted" + n;
        String jexp = castItemVar + ".convert(" + typeVar + ", " + compiler.getContextVariableName() + ")";
        if (!all) {
            jexp = "(" + itemVar + " instanceof UntypedAtomicValue ? " + jexp + " : " + castItemVar + ")";
        }
        if (Cardinality.allowsZero((int)exp.getCardinality())) {
            jexp = "(" + itemVar + "==null ? null : " + jexp + ")";
        }
        compiler.declare(AtomicValue.class, outVar, jexp, true);
        return outVar;
    }
}

