/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.TupleSorter;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.util.FastStringBuffer;

public class TupleSorterCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        TupleSorter exp = (TupleSorter)expr;
        Expression base = exp.getBaseExpression();
        String baseIter = compiler.compileToIterator(base);
        int n = compiler.getUniqueNumber();
        AtomicComparer[] comparators = exp.getComparators();
        for (int i = 0; i < comparators.length; ++i) {
            String v = compiler.compileAtomicComparer(comparators[i]);
            compiler.declare(AtomicComparer.class, "c" + n + "_" + i, v, true);
        }
        String compVar = "comparators" + n;
        FastStringBuffer clist = new FastStringBuffer(64);
        clist.append("{");
        for (int i = 0; i < comparators.length; ++i) {
            clist.append("c" + n + "_" + i + (i == comparators.length - 1 ? "}" : ", "));
        }
        compiler.declare(AtomicComparer[].class, compVar, clist.toString(), true);
        String sortedVar = "sorted" + n;
        compiler.declare(SequenceIterator.class, sortedVar, "new SortedTupleIterator(" + compiler.getContextVariableName() + ", " + baseIter + ", " + compVar + ")", true);
        String unwrappedVar = "unwrapped" + n;
        compiler.declare(SequenceIterator.class, unwrappedVar, "new MappingIterator(" + sortedVar + ", TupleSorter.TupleUnwrapper.getInstance())", true);
        return unwrappedVar;
    }
}

