/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntToIntHashMap;
import net.sf.saxon.expr.sort.IntToIntMap;
import net.sf.saxon.functions.Translate;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

public class TranslateCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        Translate exp = (Translate)expr;
        IntToIntMap map = exp.getStaticMap();
        if (map != null) {
            String mapVar = this.generateMap(compiler, map);
            String inVar = compiler.compileToItem(exp.getArguments()[0]);
            String outVar = "trans" + compiler.getUniqueNumber();
            compiler.declare(StringValue.class, outVar, "StringValue.makeStringValue(Translate.translateUsingMap(" + inVar + ".getStringValueCS(), " + mapVar + "))", true);
            return outVar;
        }
        String in0Var = compiler.compileToItem(exp.getArguments()[0]);
        String in1Var = compiler.compileToItem(exp.getArguments()[1]);
        String in2Var = compiler.compileToItem(exp.getArguments()[2]);
        String outVar = "trans" + compiler.getUniqueNumber();
        compiler.declare(StringValue.class, outVar, "StringValue.makeStringValue(Translate.translate(" + compiler.cast(in0Var, StringValue.class) + ", " + compiler.cast(in1Var, StringValue.class) + ", " + compiler.cast(in2Var, StringValue.class) + "))", true);
        return outVar;
    }

    private String generateMap(CompilerService compiler, IntToIntMap map) {
        String mapName = "translate" + compiler.getUniqueNumber();
        FastStringBuffer sb = new FastStringBuffer(256);
        sb.append("new IntToIntHashMap(" + map.size() + ");\n");
        IntIterator iter = map.keyIterator();
        while (iter.hasNext()) {
            int val;
            int key = iter.next();
            if (key == (val = map.get(key))) continue;
            sb.append("    " + mapName + ".put(" + key + ", " + val + ");\n");
        }
        compiler.emitInstanceVariable(IntToIntHashMap.class, mapName, sb.toString(), 3, true, false, null, null);
        return mapName;
    }
}

