/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class TraceCompiler
extends ExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression expr) {
        this.outputLabel(expr, compiler);
        compiler.compilePush(((Trace)expr).getArguments()[0]);
    }

    private void outputLabel(Expression expr, CompilerService compiler) {
        Value labelVal;
        Trace exp = (Trace)expr;
        Expression labelExp = exp.getArguments()[1];
        Value value = labelVal = labelExp instanceof Literal ? ((Literal)labelExp).getValue() : null;
        if (labelVal instanceof StringValue) {
            compiler.emit("System.err.println(" + CompilerService.javaEscape(((StringValue)labelVal).getStringValue()) + ");");
        } else {
            String labelVar = compiler.compileToItem(labelExp);
            compiler.emit("System.err.println(" + labelVar + ".getStringValue());");
        }
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        this.outputLabel(expr, compiler);
        return compiler.compileToItem(((Trace)expr).getArguments()[0]);
    }

    public String compileToIterator(CompilerService compiler, Expression expr) {
        this.outputLabel(expr, compiler);
        return compiler.compileToIterator(((Trace)expr).getArguments()[0]);
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction options) {
        this.outputLabel(expr, compiler);
        return compiler.compileToIterator(((Trace)expr).getArguments()[0]);
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        this.outputLabel(expr, compiler);
        return compiler.compileToCharSequence(((Trace)expr).getArguments()[0]);
    }
}

