/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Cardinality;

public abstract class ToBooleanCompiler
extends ExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression exp) {
        String var = this.compileToItem(compiler, exp);
        if (Cardinality.allowsZero((int)exp.getCardinality())) {
            compiler.emit("if (" + var + " != null) { ");
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + var + ", 0, NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        } else {
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + var + ", 0, NodeInfo.ALL_NAMESPACES);");
        }
    }

    public String compileToIterator(CompilerService compiler, Expression expr) {
        if (Cardinality.allowsZero((int)expr.getCardinality())) {
            String itemVar = this.compileToItem(compiler, expr);
            int n = compiler.getUniqueNumber();
            String var = "iter" + n;
            compiler.declare(SequenceIterator.class, var, "(" + itemVar + " == null ? EmptyIterator.getInstance() : SingletonIterator.makeIterator(" + itemVar + "))", true);
            return var;
        }
        int n = compiler.getUniqueNumber();
        String boolVar = compiler.compileToEffectiveBooleanValue(expr, new JavaDeclaration(Boolean.TYPE, "b" + n));
        String var = "iter" + n;
        compiler.declare(SequenceIterator.class, var, "SingletonIterator.makeIterator(BooleanValue.get(" + boolVar + "))", true);
        return var;
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        int n = compiler.getUniqueNumber();
        String boolVar = compiler.compileToEffectiveBooleanValue(expr, new JavaDeclaration(Boolean.TYPE, "b" + n));
        return "BooleanValue.get(" + boolVar + ")";
    }

    public abstract String compileToEffectiveBooleanValue(CompilerService var1, Expression var2, ReturnAction var3);

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        int n = compiler.getUniqueNumber();
        String boolVar = compiler.compileToEffectiveBooleanValue(expr, new JavaDeclaration(Boolean.TYPE, "b" + n));
        return "Boolean.toString(" + boolVar + ")";
    }
}

