/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.Sum;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class SumCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        Sum exp = (Sum)expr;
        Expression[] operands = exp.getArguments();
        int n = compiler.getUniqueNumber();
        String resultVar = "sum" + n;
        String contextVar = compiler.getContextVariableName();
        String iterVar = compiler.compileToIterator(operands[0]);
        boolean allowsEmpty = Cardinality.allowsZero((int)operands[0].getCardinality());
        compiler.declare(AtomicValue.class, resultVar, "Sum.total(" + iterVar + ", " + contextVar + ", null)", !allowsEmpty);
        if (allowsEmpty) {
            compiler.emit("if (" + resultVar + " == null) {");
            if (operands.length == 2) {
                String zeroVar = compiler.compileToItem(operands[1]);
                compiler.assign(resultVar, compiler.cast(zeroVar, AtomicValue.class));
            } else {
                compiler.assign(resultVar, "IntegerValue.ZERO");
            }
            compiler.emit("}");
        }
        return resultVar;
    }
}

