/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.Substring;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class SubstringCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        Substring exp = (Substring)expr;
        String in0Var = compiler.compileToItem(exp.getArguments()[0]);
        String in1Var = compiler.compileToItem(exp.getArguments()[1]);
        String in0Cast = compiler.cast(in0Var, StringValue.class);
        if (Cardinality.allowsZero((int)exp.getArguments()[0].getCardinality())) {
            in0Cast = "(" + in0Var + "==null ? StringValue.EMPTY_STRING : " + in0Cast + ")";
        }
        String in1Cast = compiler.cast(in1Var, NumericValue.class);
        if (exp.getNumberOfArguments() == 2) {
            String outVar = "substring" + compiler.getUniqueNumber();
            compiler.emit("StringValue " + outVar + " = new StringValue(Substring.substring(" + in0Cast + ", " + in1Cast + "));");
            return outVar;
        }
        String in2Var = compiler.compileToItem(exp.getArguments()[2]);
        String outVar = "substring" + compiler.getUniqueNumber();
        String in2Cast = compiler.cast(in2Var, NumericValue.class);
        compiler.declare(StringValue.class, outVar, "new StringValue(Substring.substring(" + in0Cast + ", " + in1Cast + ", " + in2Cast + ", " + compiler.getContextVariableName() + "))", true);
        return outVar;
    }
}

