/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;

public class StringLengthCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        StringLength exp = (StringLength)expr;
        if (exp.getArguments().length == 0) {
            String outVar = "len" + compiler.getUniqueNumber();
            compiler.declare(Int64Value.class, outVar, "Int64Value.makeIntegerValue(StringValue.getStringLength(" + compiler.getContextItemVariableName() + ".getStringValueCS()))", true);
            return outVar;
        }
        String inVar = compiler.compileToItem(exp.getArguments()[0]);
        String outVar = "len" + compiler.getUniqueNumber();
        String initializer = "Int64Value.makeIntegerValue(StringValue.getStringLength(" + inVar + ".getStringValueCS()))";
        if (Cardinality.allowsZero((int)exp.getArguments()[0].getCardinality())) {
            initializer = "( " + inVar + "==null ? IntegerValue.ZERO : " + initializer + " )";
        }
        compiler.declare(Int64Value.class, outVar, initializer, true);
        return outVar;
    }
}

