/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class StringFnCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        StringFn exp = (StringFn)expr;
        String invar = compiler.compileToItem(exp.getArguments()[0]);
        String outvar = "m" + compiler.getUniqueNumber();
        String jexp = "StringValue.makeStringValue(" + invar + ".getStringValueCS())";
        if (Cardinality.allowsZero((int)exp.getArguments()[0].getCardinality())) {
            jexp = "(" + invar + "==null ? StringValue.EMPTY_STRING : " + jexp + ")";
        }
        compiler.declare(StringValue.class, outvar, jexp, true);
        return outvar;
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        StringFn exp = (StringFn)expr;
        String invar = compiler.compileToItem(exp.getArguments()[0]);
        String outvar = "m" + compiler.getUniqueNumber();
        String jexp = invar + ".getStringValueCS()";
        if (Cardinality.allowsZero((int)exp.getArguments()[0].getCardinality())) {
            jexp = "(" + invar + "==null ? \"\" : " + jexp + ")";
        }
        compiler.declare(CharSequence.class, outvar, jexp, true);
        return outvar;
    }
}

