/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Int64Value;

public class SlashExpressionCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        SlashExpression exp = (SlashExpression)expr;
        int n = compiler.getUniqueNumber();
        String uncheckedVar = "u" + n;
        String resultVar = "s" + n;
        Expression head = exp.getControllingExpression();
        Expression tail = exp.getControlledExpression();
        boolean usesPosition = (tail.getDependencies() & 4) != 0;
        String masterVar = compiler.compileToIterator(head);
        String cmf = "cmf" + n;
        String itemVar = "item" + n;
        String positionVar = "pos" + n;
        String boxedPositionVar = "position" + n;
        String mfVar = "mf" + n;
        compiler.emit("MappingFunction " + cmf + " = new MappingFunction() { // mapping expression");
        if (usesPosition) {
            compiler.declare(Integer.TYPE, positionVar, "0", false);
        }
        compiler.emit("public SequenceIterator map(final Item " + itemVar + ") throws XPathException {");
        compiler.pushContextItemVariable(itemVar);
        if (usesPosition) {
            compiler.declare(Int64Value.class, boxedPositionVar, "new Int64Value(++" + positionVar + ")", true);
            compiler.pushContextPositionVariable(boxedPositionVar);
        }
        String stepVar = compiler.compileToIterator(tail);
        compiler.emit("return " + stepVar + ";");
        compiler.popContextItemVariable();
        if (usesPosition) {
            compiler.popContextPositionVariable();
        }
        compiler.emit("}");
        compiler.emit("};");
        compiler.declare(SequenceIterator.class, uncheckedVar, "new MappingIterator(" + masterVar + ", " + cmf + ")", true);
        compiler.declare(SequenceIterator.class, resultVar, null, false);
        String firstVar = "first" + n;
        compiler.declare(Item.class, firstVar, uncheckedVar + ".next()", true);
        compiler.emit("if (" + firstVar + "==null) {");
        compiler.assign(resultVar, "EmptyIterator.getInstance()");
        compiler.emit("} else if (" + firstVar + " instanceof AtomicValue) {");
        compiler.emit("ItemMappingFunction " + mfVar + " = new ItemMappingFunction() { // check all atomic");
        compiler.emit("public Item mapItem(Item item) throws XPathException {");
        compiler.emit("if (item instanceof AtomicValue) {");
        compiler.emit("return item;");
        compiler.emit("} else {");
        compiler.emitDynamicError("Sequence contains a mix of nodes and atomic values", "XPTY0018");
        compiler.emit("return null;");
        compiler.emit("}");
        compiler.emit("}");
        compiler.emit("};");
        compiler.assign(resultVar, "new EveryItemMappingIterator(" + uncheckedVar + ".getAnother(), " + mfVar + ")");
        compiler.emit("} else {");
        compiler.emit("ItemMappingFunction " + mfVar + " = new ItemMappingFunction() { // check all nodes");
        compiler.emit("public Item mapItem(Item item) throws XPathException {");
        compiler.emit("if (item instanceof NodeInfo) {");
        compiler.emit("return item;");
        compiler.emit("} else {");
        compiler.emitDynamicError("Sequence contains a mix of nodes and atomic values", "XPTY0018");
        compiler.emit("return null;");
        compiler.emit("}");
        compiler.emit("}");
        compiler.emit("};");
        compiler.assign(resultVar, "new DocumentOrderIterator(new EveryItemMappingIterator(" + uncheckedVar + ".getAnother(), " + mfVar + "), GlobalOrderComparer.getInstance())");
        compiler.emit("}");
        return resultVar;
    }
}

