/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SingletonAtomizer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public class SingletonAtomizerCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        String itemVar;
        SingletonAtomizer exp = (SingletonAtomizer)expr;
        RoleLocator role = exp.getRole();
        int n = compiler.getUniqueNumber();
        String foundVar = "found" + n;
        String resultVar = "m" + n;
        boolean closeWhile = false;
        compiler.declare(Integer.TYPE, foundVar, "0", false);
        compiler.declare(AtomicValue.class, resultVar, "null", false);
        if (Cardinality.allowsMany((int)exp.getBaseExpression().getCardinality())) {
            String iterVar = compiler.compileToIterator(exp.getBaseExpression());
            compiler.emit("while (true) {");
            closeWhile = true;
            itemVar = resultVar + "item";
            compiler.emit("Item " + itemVar + " = " + iterVar + ".next();");
            compiler.emit("if (" + itemVar + " == null) break;");
        } else {
            itemVar = compiler.compileToItem(exp.getBaseExpression());
        }
        TypeHierarchy th = compiler.getTypeHierarchy();
        boolean closeOuterIf = false;
        if (!th.isSubType(exp.getBaseExpression().getItemType(th), Type.NODE_TYPE)) {
            compiler.emit("if (" + itemVar + " instanceof AtomicValue) {");
            compiler.emit(foundVar + "++;");
            compiler.emit(resultVar + " = (AtomicValue)" + itemVar + ";");
            compiler.emit("} else {");
            closeOuterIf = true;
        }
        String valueVar = resultVar + "value";
        boolean closeInnerIf = false;
        if (Cardinality.allowsZero((int)exp.getBaseExpression().getCardinality())) {
            closeInnerIf = true;
            compiler.emit("if (" + itemVar + " == null) {");
            compiler.assign(resultVar, "null");
            compiler.emit("} else {");
        }
        String jexp = compiler.cast(itemVar, NodeInfo.class) + ".atomize()";
        compiler.declare(Value.class, valueVar, jexp, true);
        compiler.emit(foundVar + " += " + valueVar + ".getLength();");
        compiler.emit(resultVar + " = (AtomicValue)" + valueVar + ".itemAt(0);");
        if (closeInnerIf) {
            compiler.emit("}");
        }
        if (closeOuterIf) {
            compiler.emit("}");
        }
        compiler.emit("if (" + foundVar + " > 1) {");
        compiler.emitDynamicError("A sequence of more than one item is not allowed as the " + role.getMessage(), role.getErrorCode());
        compiler.emit("}");
        if (closeWhile) {
            compiler.emit("}");
        }
        if (!Cardinality.allowsZero((int)exp.getCardinality())) {
            compiler.emit("if (" + foundVar + " == 0) {");
            compiler.emitDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
            compiler.emit("}");
        }
        return resultVar;
    }
}

