/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.Cardinality;

public abstract class SequenceExpressionCompiler
extends ExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression exp) {
        String iter = this.compileToIterator(compiler, exp);
        String vbl = "item" + compiler.getUniqueNumber();
        compiler.declare(Item.class, vbl, iter + ".next()", true);
        return vbl;
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        String iter = this.compileToIterator(compiler, expr);
        compiler.emit(result.output(compiler, "ExpressionTool.effectiveBooleanValue(" + iter + ")"));
        return result.getVariableName();
    }

    public void compilePush(CompilerService compiler, Expression exp) {
        int loc = exp.getLocationId();
        if (Cardinality.allowsMany((int)exp.getCardinality())) {
            String iter = this.compileToIterator(compiler, exp);
            String vbl = "it" + compiler.getUniqueNumber();
            compiler.emit("while (true) {");
            compiler.emit("Item " + vbl + " = " + iter + ".next();");
            compiler.emit("if (" + vbl + " == null) break;");
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + vbl + ", " + loc + ", NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        } else if (Cardinality.allowsZero((int)exp.getCardinality())) {
            String item = this.compileToItem(compiler, exp);
            compiler.emit("if (" + item + " != null) {");
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + item + ", " + loc + ", NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        } else {
            String item = this.compileToItem(compiler, exp);
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + item + ", " + loc + ", NodeInfo.ALL_NAMESPACES);");
        }
    }
}

