/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.Rounding;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class RoundingCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        Rounding exp = (Rounding)expr;
        Expression[] operands = exp.getArguments();
        int operator = exp.getDetails().opcode;
        int n = compiler.getUniqueNumber();
        String resultVar = compiler.makeValidJavaName(exp.getDetails().name) + n;
        boolean conditional = false;
        String argVar = compiler.compileToItem(operands[0]);
        if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
            conditional = true;
            compiler.declare(NumericValue.class, resultVar, null, false);
            compiler.emit("if (" + argVar + " == null) {");
            compiler.emit(resultVar + " = null;");
            compiler.emit("} else {");
        }
        String valueExpression = null;
        String argNumeric = compiler.cast(argVar, NumericValue.class);
        switch (operator) {
            case 2: {
                if (operands.length == 2) {
                    if (Literal.isAtomic((Expression)operands[1])) {
                        valueExpression = argNumeric + ".round(" + ((AtomicValue)((Literal)operands[1]).getValue()).getStringValue() + ")";
                        break;
                    }
                    String scaleVar = compiler.compileToItem(operands[1]);
                    valueExpression = argNumeric + ".round((int)" + compiler.cast(scaleVar, IntegerValue.class) + ".longValue())";
                    break;
                }
                valueExpression = argNumeric + ".round(0)";
                break;
            }
            case 0: {
                valueExpression = argNumeric + ".floor()";
                break;
            }
            case 1: {
                valueExpression = argNumeric + ".ceiling()";
                break;
            }
            case 4: {
                valueExpression = argNumeric + ".abs()";
                break;
            }
            case 3: {
                if (operands.length == 2) {
                    if (Literal.isAtomic((Expression)operands[1])) {
                        valueExpression = argNumeric + ".roundHalfToEven(" + ((AtomicValue)((Literal)operands[1]).getValue()).getStringValue() + ")";
                        break;
                    }
                    String scaleVar = compiler.compileToItem(operands[1]);
                    valueExpression = argNumeric + ".roundHalfToEven((int)" + compiler.cast(scaleVar, IntegerValue.class) + ".longValue())";
                    break;
                }
                valueExpression = argNumeric + ".roundHalfToEven(0)";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized rounding operator " + operator);
            }
        }
        if (conditional) {
            compiler.assign(resultVar, valueExpression);
            compiler.emit("}");
        } else {
            compiler.declare(NumericValue.class, resultVar, valueExpression, true);
        }
        return resultVar;
    }
}

