/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class ResolveURICompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        String base;
        ResolveURI exp = (ResolveURI)expr;
        Expression relativeUriArg = exp.getArguments()[0];
        int n = compiler.getUniqueNumber();
        String resultVar = "uri" + n;
        boolean conditional = false;
        compiler.declare(AnyURIValue.class, resultVar, "null", false);
        int card0 = relativeUriArg.getCardinality();
        if (card0 == 8192) {
            compiler.assign(resultVar, "null");
            return resultVar;
        }
        String relativeUriVar = compiler.compileToItem(relativeUriArg);
        if (Cardinality.allowsZero((int)card0)) {
            conditional = true;
            compiler.emit("if (" + relativeUriVar + " == null) {");
            compiler.assign(resultVar, "null");
            compiler.emit("} else {");
        }
        relativeUriVar = relativeUriVar + ".getStringValue()";
        if (exp.getNumberOfArguments() == 1) {
            base = CompilerService.javaEscape(exp.getStaticBaseURI());
        } else {
            Value baseVal;
            Expression baseArg = exp.getArguments()[1];
            Value value = baseVal = baseArg instanceof Literal ? ((Literal)baseArg).getValue() : null;
            if (baseVal instanceof StringValue) {
                base = CompilerService.javaEscape(((StringValue)baseVal).getStringValue());
            } else {
                String baseVar = compiler.compileToItem(baseArg);
                base = baseVar + ".getStringValue()";
            }
        }
        String calc = "new AnyURIValue(ResolveURI.makeAbsolute(" + relativeUriVar + ", " + base + ").toString())";
        compiler.emit("try {");
        compiler.assign(resultVar, calc);
        compiler.emit("} catch (java.net.URISyntaxException err) {");
        compiler.emitDynamicError("Base URI is invalid", "FORG0002");
        compiler.emit("}");
        if (conditional) {
            compiler.emit("}");
        }
        return resultVar;
    }
}

