/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.deploy.CompiledUserQuery;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.Result;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaException;

public class QueryCompiler {
    private Configuration config;
    private String baseURI;
    private String className = "Query";
    private String superClassName;
    private File errorFile;
    private File outputDirectory;
    private boolean explain;
    private boolean servletMode;
    private boolean convertUntypedAtomicParameters = false;

    public QueryCompiler(Configuration config) {
        this.config = config;
    }

    public void setConvertUntypedAtomicParameters(boolean un) {
        this.convertUntypedAtomicParameters = un;
    }

    public boolean isConvertUntypedAtomicParameters() {
        return this.convertUntypedAtomicParameters;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setErrorFile(File errorFile) {
        this.errorFile = errorFile;
    }

    public File getErrorFile() {
        return this.errorFile;
    }

    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public void setServletMode(boolean servlet) {
        this.servletMode = servlet;
    }

    public boolean isInServletMode() {
        return this.servletMode;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setSuperClassName(String className) {
        this.superClassName = className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public File compileQueryToJava(InputStream input, String encoding) throws XPathException {
        PrintWriter pw;
        File javaFile;
        String localClassName;
        XQueryExpression qex;
        StaticQueryContext sqc = this.config.newStaticQueryContext();
        if (this.baseURI == null) {
            throw new XPathException("Base URI of query not supplied");
        }
        sqc.setBaseURI(this.baseURI);
        sqc.setGeneratingJavaCode(true);
        try {
            qex = sqc.compileQuery(input, encoding);
        }
        catch (IOException err) {
            throw new XPathException("Failed to read input query");
        }
        if (this.explain) {
            ExpressionPresenter out = new ExpressionPresenter(this.config);
            qex.explain(out);
            out.close();
        }
        Expression exp = qex.getExpression();
        CompilerService compiler = new CompilerService();
        compiler.setConvertUntypedAtomicParameters(this.convertUntypedAtomicParameters);
        QueryModule module = qex.getStaticContext();
        String packageName = null;
        int sep = this.className.lastIndexOf(46);
        if (sep >= 0) {
            localClassName = this.className.substring(sep + 1);
            packageName = this.className.substring(0, sep);
            FastStringBuffer fsb = new FastStringBuffer(packageName.length());
            for (int i = 0; i < packageName.length(); ++i) {
                char c = packageName.charAt(i);
                fsb.append(c == '.' ? (char)'/' : (char)c);
            }
            File dir = new File(this.outputDirectory + "/" + fsb.toString());
            dir.mkdirs();
            String localName = this.className.substring(sep + 1);
            javaFile = new File(dir, localName + ".java");
        } else {
            localClassName = this.className;
            javaFile = new File(this.outputDirectory + "/" + this.className + ".java");
        }
        try {
            pw = new PrintWriter(new FileOutputStream(javaFile));
        }
        catch (IOException err) {
            throw new XPathException("Failed to create writer for Java output file", (Throwable)err);
        }
        compiler.setPrintWriter(pw);
        compiler.setClassName(packageName, localClassName);
        compiler.setBaseURI(this.baseURI);
        compiler.setServletMode(this.servletMode);
        compiler.setSuperClassName(this.superClassName);
        compiler.prologue(true);
        compiler.setConfiguration(this.config);
        compiler.setExecutable(qex.getExecutable());
        compiler.compileImportedSchemata(qex.getStaticContext().getAllImportedSchemata());
        HashSet<GlobalVariable> emittedVariables = new HashSet<GlobalVariable>();
        HashSet pendingVariables = new HashSet();
        HashMap variables = qex.getExecutable().getCompiledGlobalVariables();
        if (variables != null) {
            pendingVariables.addAll(variables.values());
        }
        int loops = 0;
        while (loops++ < 10000 && !pendingVariables.isEmpty()) {
            for (GlobalVariable var : pendingVariables) {
                ArrayList dependentVariables = new ArrayList(10);
                Expression select = var.getSelectExpression();
                boolean ok = true;
                if (select != null) {
                    ExpressionTool.gatherReferencedVariables((Expression)select, dependentVariables);
                    for (int v = 0; v < dependentVariables.size(); ++v) {
                        Binding b = (Binding)dependentVariables.get(v);
                        if (!b.isGlobal() || emittedVariables.contains(b)) continue;
                        ok = false;
                    }
                }
                if (!ok) continue;
                compiler.compileGlobalVariable(var);
                emittedVariables.add(var);
            }
            for (GlobalVariable var : emittedVariables) {
                pendingVariables.remove(var);
            }
        }
        XQueryFunctionLibrary lib = module.getGlobalFunctionLibrary();
        Iterator fIter = lib.getFunctionDefinitions();
        while (fIter.hasNext()) {
            XQueryFunction fn = (XQueryFunction)fIter.next();
            compiler.compileFunction(fn);
        }
        compiler.compileMainExpression(exp);
        compiler.epilogue();
        return javaFile;
    }

    public void runQuery(DynamicQueryContext dqc, Result result, Properties properties) throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, SchemaException, XPathException {
        URLClassLoader usercodeLoader = new URLClassLoader(new URL[]{this.outputDirectory.toURL()});
        Class<?> userClass = usercodeLoader.loadClass(this.className);
        CompiledUserQuery q = (CompiledUserQuery)userClass.newInstance();
        q.setConfiguration(this.config);
        q.setDynamicContext(dqc);
        try {
            q.importSchemata(this.config);
        }
        catch (SchemaException e) {
            System.err.println("Warning: schema import failed. " + e.getMessage());
        }
        q.run(result, properties);
    }
}

