/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Cardinality;

public class PathExpressionCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        PathExpression exp = (PathExpression)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = "s" + n;
        Expression head = exp.getFirstStep();
        if (Cardinality.allowsMany((int)head.getCardinality())) {
            String masterVar = compiler.compileToIterator(head);
            Expression tail = exp.getRemainingSteps();
            String cmf = "cmf" + n;
            String itemVar = "node" + n;
            compiler.emit("MappingFunction " + cmf + " = new MappingFunction() { // path expression");
            compiler.emit("public SequenceIterator map(final Item " + itemVar + ") throws XPathException {");
            compiler.pushContextItemVariable(itemVar);
            String stepVar = compiler.compileToIterator(tail);
            compiler.emit("return " + stepVar + ";");
            compiler.popContextItemVariable();
            compiler.emit("}");
            compiler.emit("};");
            compiler.declare(SequenceIterator.class, resultVar, "new MappingIterator(" + masterVar + ", " + cmf + ")", true);
            return resultVar;
        }
        if (Cardinality.allowsZero((int)head.getCardinality())) {
            String masterVar = compiler.compileToItem(head);
            compiler.emit("SequenceIterator " + resultVar + ";");
            compiler.emit("if (" + masterVar + " != null) {");
            compiler.pushContextItemVariable(masterVar);
            String stepVar = compiler.compileToIterator(exp.getRemainingSteps());
            compiler.popContextItemVariable();
            compiler.assign(resultVar, stepVar);
            compiler.emit("} else {");
            compiler.assign(resultVar, "EmptyIterator.getInstance()");
            compiler.emit("}");
            return resultVar;
        }
        String masterVar = compiler.compileToItem(head);
        compiler.pushContextItemVariable(masterVar);
        String stepVar = compiler.compileToIterator(exp.getRemainingSteps());
        compiler.popContextItemVariable();
        return stepVar;
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        PathExpression exp = (PathExpression)expr;
        int loc = exp.getLocationId();
        if (Cardinality.allowsMany((int)exp.getCardinality())) {
            Expression head = exp.getFirstStep();
            if (Cardinality.allowsMany((int)head.getCardinality())) {
                String masterVar = compiler.compileToIterator(head);
                Expression tail = exp.getRemainingSteps();
                if (tail instanceof AxisExpression) {
                    int n = compiler.getUniqueNumber();
                    NodeTest test = ((AxisExpression)tail).getNodeTest();
                    String testVar = null;
                    if (test != null) {
                        testVar = compiler.compileNodeTest(test);
                    }
                    byte axis = ((AxisExpression)tail).getAxis();
                    String iterVar = "iter" + n;
                    compiler.emit("while (true) {");
                    String itemVar = "node" + n;
                    compiler.declare(Item.class, itemVar, masterVar + ".next()", true);
                    compiler.emit("if (" + itemVar + " == null) break;");
                    compiler.declare(AxisIterator.class, iterVar, "((NodeInfo)" + itemVar + ").iterateAxis((byte)" + axis + (test == null ? "" : ", " + testVar) + ")", true);
                    compiler.emit("while (true) {");
                    String innerItemVar = "nodeInner" + n;
                    compiler.declare(Item.class, innerItemVar, iterVar + ".next()", true);
                    compiler.emit("if (" + innerItemVar + " == null) break;");
                    compiler.emit(compiler.getOutputterVariableName() + ".append(" + innerItemVar + ", " + "0, NodeInfo.ALL_NAMESPACES);");
                    compiler.emit("}");
                    compiler.emit("}");
                } else {
                    int n = compiler.getUniqueNumber();
                    compiler.emit("while (true) {");
                    String itVar = "node" + n;
                    compiler.pushContextItemVariable(itVar);
                    compiler.pushContextPositionVariable(itVar + ".position()");
                    compiler.declare(Item.class, itVar, masterVar + ".next()", true);
                    compiler.emit("if (" + itVar + " == null) break;");
                    compiler.compilePush(tail);
                    compiler.emit("}");
                    compiler.popContextItemVariable();
                    compiler.popContextPositionVariable();
                }
            } else {
                int n = compiler.getUniqueNumber();
                String masterVar = compiler.compileToItem(head);
                compiler.emit("if (" + masterVar + " != null) {");
                Expression tail = exp.getRemainingSteps();
                String iterVar = "si" + n;
                String itemVar = "node" + n;
                compiler.emit("AxisIterator " + iterVar + " = SingleNodeIterator.makeIterator((NodeInfo)" + masterVar + ");");
                compiler.declare(Item.class, itemVar, iterVar + ".next()", true);
                compiler.pushContextItemVariable(itemVar);
                compiler.emit("if (" + itemVar + " != null) {");
                compiler.compilePush(tail);
                compiler.emit("}");
                compiler.emit("}");
                compiler.popContextItemVariable();
            }
        } else {
            String item = this.compileToItem(compiler, (Expression)exp);
            compiler.emit("if (" + item + " != null) {");
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + item + ", " + loc + ", NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        }
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, final LoopAction action) {
        final PathExpression exp = (PathExpression)expr;
        Expression first = exp.getFirstStep();
        if (Cardinality.allowsMany((int)first.getCardinality())) {
            LoopAction outerAction = new LoopAction(){

                public void compileAction(CompilerService compiler, String itemVar) {
                    compiler.pushContextItemVariable(itemVar);
                    compiler.compileAsLoop(exp.getRemainingSteps(), action);
                    compiler.popContextItemVariable();
                }
            };
            compiler.compileAsLoop(first, outerAction);
        } else if (Cardinality.allowsZero((int)first.getCardinality())) {
            String itemVar = compiler.compileToItem(first);
            compiler.emit("if (" + itemVar + " != null) {");
            compiler.pushContextItemVariable(itemVar);
            compiler.compileAsLoop(exp.getRemainingSteps(), action);
            compiler.popContextItemVariable();
            compiler.emit("}");
        } else {
            String itemVar = compiler.compileToItem(first);
            compiler.pushContextItemVariable(itemVar);
            compiler.compileAsLoop(exp.getRemainingSteps(), action);
            compiler.popContextItemVariable();
        }
    }
}

