/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.NumericPromoter;
import net.sf.saxon.expr.PromoteToDouble;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ItemType;

public class NumericPromoterCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        NumericPromoter exp = (NumericPromoter)expr;
        boolean toDouble = exp instanceof PromoteToDouble;
        String sequenceVar = compiler.compileToIterator(exp.getBaseExpression());
        int n = compiler.getUniqueNumber();
        String mf = "mf" + n;
        String resultVar = "s" + n;
        compiler.emit("ItemMappingFunction " + mf + " = new ItemMappingFunction() { // numeric promotion ");
        compiler.emit("public Item mapItem(Item item) throws XPathException {");
        this.compileNumericPromotion(compiler, "item", "return", toDouble ? 517 : 516);
        compiler.emit("}");
        compiler.emit("};");
        compiler.emit("SequenceIterator " + resultVar + " = new ItemMappingIterator(" + sequenceVar + ", " + mf + ");");
        return resultVar;
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        NumericPromoter exp = (NumericPromoter)expr;
        boolean toDouble = exp instanceof PromoteToDouble;
        int n = compiler.getUniqueNumber();
        String num = "num" + n;
        String var = compiler.compileToItem(exp.getBaseExpression());
        compiler.declare(Item.class, num, "null", false);
        this.compileNumericPromotion(compiler, var, num + " = ", toDouble ? 517 : 516);
        return num;
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, final LoopAction action) {
        NumericPromoter exp = (NumericPromoter)expr;
        boolean toDouble = exp instanceof PromoteToDouble;
        final int req = toDouble ? 517 : 516;
        int n = compiler.getUniqueNumber();
        final String outVar = "num" + n;
        LoopAction convertAction = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                NumericPromoterCompiler.this.compileNumericPromotion(compiler, itemVar, outVar + " = ", req);
                action.compileAction(compiler, outVar);
            }
        };
        compiler.emit("Item " + outVar + " = null;");
        compiler.compileAsLoop(exp.getBaseExpression(), convertAction);
    }

    private void compileNumericPromotion(CompilerService compiler, String inVar, String outVar, int requiredType) {
        compiler.emit("if ((AtomicValue)" + inVar + " instanceof NumericValue || (AtomicValue)" + inVar + " instanceof UntypedAtomicValue) {");
        compiler.emit(outVar + "((AtomicValue)" + inVar + ").convert(" + compiler.compileItemType((ItemType)((AtomicType)BuiltInType.getSchemaType((int)requiredType))) + ", " + compiler.getContextVariableName() + ");");
        compiler.emit("} else {");
        compiler.emitDynamicError("Cannot promote non-numeric value", "XPTY0004");
        if (outVar.equals("return")) {
            compiler.emit("return null;");
        }
        compiler.emit("}");
    }
}

