/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class NormalizeSpaceCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        NormalizeSpace exp = (NormalizeSpace)expr;
        Expression[] operands = exp.getArguments();
        int n = compiler.getUniqueNumber();
        String resultVar = compiler.makeValidJavaName(exp.getDetails().name) + n;
        boolean conditional = false;
        if (operands.length == 0) {
            compiler.declare(StringValue.class, resultVar, "StringValue.makeStringValue(Whitespace.collapseWhitespace(" + compiler.getContextItemVariableName() + ".getStringValueCS()))", true);
        } else {
            String argVar = compiler.compileToItem(operands[0]);
            if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
                conditional = true;
                compiler.declare(StringValue.class, resultVar, null, false);
                compiler.emit("if (" + argVar + " == null) {");
                compiler.emit(resultVar + " = StringValue.EMPTY_STRING;");
                compiler.emit("} else {");
            }
            String valueExpression = "StringValue.makeStringValue(Whitespace.collapseWhitespace(" + argVar + ".getStringValueCS()))";
            if (conditional) {
                compiler.assign(resultVar, valueExpression);
                compiler.emit("}");
            } else {
                compiler.declare(StringValue.class, resultVar, valueExpression, true);
            }
        }
        return resultVar;
    }
}

