/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;

public class NamePartCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        NamePart exp = (NamePart)expr;
        int operation = exp.getDetails().opcode;
        String invar = compiler.compileToItem(exp.getArguments()[0]);
        int n = compiler.getUniqueNumber();
        String outvar = "m" + n;
        switch (operation) {
            case 0: {
                String jnameexp = "(" + invar + " == null ? \"\" : " + compiler.cast(invar, NodeInfo.class) + ".getDisplayName())";
                compiler.declare(StringValue.class, outvar, "StringValue.makeStringValue(" + jnameexp + ")", true);
                break;
            }
            case 1: {
                String jlocalexp = "(" + invar + " == null ? \"\" : " + compiler.cast(invar, NodeInfo.class) + ".getLocalPart())";
                compiler.declare(StringValue.class, outvar, "StringValue.makeStringValue(" + jlocalexp + ")", true);
                break;
            }
            case 2: {
                String jnsexp = "(" + invar + " == null ? \"\" : " + compiler.cast(invar, NodeInfo.class) + ".getURI())";
                compiler.declare(AnyURIValue.class, outvar, "new AnyURIValue(" + jnsexp + ")", true);
                break;
            }
            case 3: {
                String fsbVar = outvar + "fsb";
                compiler.declare(FastStringBuffer.class, fsbVar, "new FastStringBuffer(25)", true);
                compiler.emit(compiler.cast(invar, NodeInfo.class) + ".generateId(" + fsbVar + ")");
                compiler.declare(StringValue.class, outvar, "new StringValue(" + fsbVar + ")", true);
                break;
            }
            case 4: {
                compiler.declare(StringValue.class, outvar, null, false);
                compiler.emit("if ( " + invar + " != null && " + compiler.cast(invar, NodeInfo.class) + ".getNodeKind() == Type.DOCUMENT) {");
                String poolVar = "pool" + n;
                String uriVar = "uri" + n;
                compiler.declare(DocumentPool.class, poolVar, compiler.getContextVariableName() + ".getController().getDocumentPool()", true);
                compiler.declare(String.class, uriVar, poolVar + ".getDocumentURI(" + compiler.cast(invar, NodeInfo.class) + ")", false);
                compiler.emit("if (" + uriVar + " == null) {");
                compiler.assign(uriVar, compiler.cast(invar, NodeInfo.class) + ".getSystemId()");
                compiler.emit("}");
                compiler.emit(outvar + " = " + "(" + uriVar + "==null || " + uriVar + ".length()==0 ? null : new AnyURIValue(" + uriVar + "));");
                compiler.emit("} else {");
                compiler.assign(outvar, "null");
                compiler.emit("}");
                break;
            }
            case 6: {
                String ncvar = outvar + "nc";
                String jnnexp = "(" + invar + " == null ? -1 : " + compiler.cast(invar, NodeInfo.class) + ".getNameCode())";
                compiler.declare(Integer.TYPE, ncvar, jnnexp, true);
                compiler.declare(QualifiedNameValue.class, outvar, "(" + ncvar + " < 0 ? null : new QNameValue(namePool, " + ncvar + "))", true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown name operation");
            }
        }
        return outvar;
    }
}

