/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonComparisonCompiler;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;

public class MinimaxCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        String compVar;
        Minimax exp = (Minimax)expr;
        Expression[] operands = exp.getArguments();
        int operator = exp.getDetails().opcode;
        int n = compiler.getUniqueNumber();
        TypeHierarchy th = compiler.getTypeHierarchy();
        String resultVar = "minmax" + n;
        if (operands[0] instanceof Block && ((Block)operands[0]).getChildren().length == 2 && ((Block)operands[0]).getChildren()[0].getCardinality() == 16384 && ((Block)operands[0]).getChildren()[1].getCardinality() == 16384 && ((Block)operands[0]).getChildren()[0].getItemType(th).getPrimitiveType() == ((Block)operands[0]).getChildren()[1].getItemType(th).getPrimitiveType() && exp.getStringCollator() != null) {
            String v0 = compiler.compileToItem(((Block)operands[0]).getChildren()[0]);
            String v1 = compiler.compileToItem(((Block)operands[0]).getChildren()[1]);
            BuiltInAtomicType type = (BuiltInAtomicType)operands[0].getItemType(th).getPrimitiveItemType();
            if (type == BuiltInAtomicType.UNTYPED_ATOMIC) {
                type = BuiltInAtomicType.DOUBLE;
            }
            StringCollator sc = exp.getStringCollator();
            AtomicComparer comp = GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)type, (BuiltInAtomicType)type, (StringCollator)sc, (XPathContext)compiler.getConfiguration().getConversionContext());
            String jexp = SingletonComparisonCompiler.compileComparison(comp, v0, compiler, v1, operator == 2 ? 53 : 52);
            compiler.declare(Item.class, resultVar, "(" + jexp + " ? " + "(AtomicValue)" + v0 + " : " + "(AtomicValue)" + v1 + ")", true);
            return resultVar;
        }
        String iterVar = compiler.compileToIterator(operands[0]);
        StringCollator sc = exp.getStringCollator();
        if (sc != null) {
            BuiltInAtomicType type = (BuiltInAtomicType)operands[0].getItemType(th).getPrimitiveItemType();
            if (type == BuiltInAtomicType.UNTYPED_ATOMIC) {
                type = BuiltInAtomicType.DOUBLE;
            }
            AtomicComparer comp = GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)type, (BuiltInAtomicType)type, (StringCollator)sc, (XPathContext)compiler.getConfiguration().getConversionContext());
            compVar = compiler.compileAtomicComparer(comp);
        } else {
            String collVar = compiler.compileStringCollator((CollatingFunction)exp, 1);
            compVar = "comparer" + n;
            compiler.declare(GenericAtomicComparer.class, compVar, "new GenericAtomicComparer(" + collVar + ", " + compiler.getContextVariableName() + ")", true);
        }
        compiler.emit("AtomicValue " + resultVar + " = Minimax.minimax(" + iterVar + ", " + operator + ", " + compVar + ", " + exp.isIgnoreNaN() + ", " + compiler.getContextVariableName() + ");");
        return resultVar;
    }
}

