/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;

public class LocalVariableReferenceCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        LocalVariableReference exp = (LocalVariableReference)expr;
        String vblout = "v" + compiler.getUniqueNumber();
        compiler.declare(SequenceIterator.class, vblout, "Value.asIterator(" + compiler.getXPathVariableName(exp.getSlotNumber()) + ")", true);
        return vblout;
    }

    public String compileToValueRepresentation(CompilerService compiler, Expression expr) {
        LocalVariableReference exp = (LocalVariableReference)expr;
        String varName = compiler.getXPathVariableName(exp.getSlotNumber());
        if (compiler.isInstance(varName, ValueRepresentation.class)) {
            return varName;
        }
        return super.compileToValueRepresentation(compiler, expr);
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        LocalVariableReference exp = (LocalVariableReference)expr;
        String varName = compiler.getXPathVariableName(exp.getSlotNumber());
        if (compiler.isInstance(varName, Item.class)) {
            return varName;
        }
        String vblout = "v" + compiler.getUniqueNumber();
        compiler.declare(Item.class, vblout, "Value.asItem(" + varName + ")", true);
        return vblout;
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        LocalVariableReference exp = (LocalVariableReference)expr;
        String varName = compiler.getXPathVariableName(exp.getSlotNumber());
        if (compiler.isInstance(varName, Item.class)) {
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + varName + ", 0, NodeInfo.ALL_NAMESPACES);");
        } else {
            super.compilePush(compiler, expr);
        }
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        String item = this.compileToItem(compiler, expr);
        return "(" + item + " == null ? \"\" : " + item + ".getStringValueCS())";
    }
}

