/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public class LiteralCompiler
extends ExpressionCompiler {
    private ValueCompiler valueCompiler;

    public LiteralCompiler(ValueCompiler avc) {
        this.valueCompiler = avc;
    }

    public void compilePush(CompilerService compiler, Expression exp) {
        this.valueCompiler.compilePush(compiler, ((Literal)exp).getValue());
    }

    public String compileToValueRepresentation(CompilerService compiler, Expression expr) {
        try {
            Value value = ((Literal)expr).getValue().reduce();
            if (value instanceof EmptySequence) {
                return "EmptySequence.getInstance()";
            }
            if (value instanceof AtomicValue) {
                return this.valueCompiler.compileToItem(compiler, (AtomicValue)value);
            }
            return super.compileToValueRepresentation(compiler, expr);
        }
        catch (XPathException e) {
            return super.compileToValueRepresentation(compiler, expr);
        }
    }

    public String compileToItem(CompilerService compiler, Expression exp) {
        try {
            Value value = ((Literal)exp).getValue().reduce();
            if (value instanceof EmptySequence) {
                return "null";
            }
            if (value instanceof AtomicValue) {
                return compiler.getValueCompiler(value).compileToItem(compiler, (AtomicValue)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new UnsupportedOperationException("compileToItem called on non-atomic value");
    }

    public String compileToIterator(CompilerService compiler, Expression exp) {
        return this.valueCompiler.compileToIterator(compiler, ((Literal)exp).getValue());
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression exp, ReturnAction options) {
        return this.valueCompiler.compileToEffectiveBooleanValue(compiler, ((Literal)exp).getValue(), options);
    }

    public String compileToCharSequence(CompilerService compiler, Expression exp) {
        if (Literal.isEmptySequence((Expression)exp)) {
            return "\"\"";
        }
        return CompilerService.javaEscape(((AtomicValue)((Literal)exp).getValue()).getStringValue());
    }
}

