/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import com.saxonica.deploy.ItemClosure;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.type.TypeHierarchy;

public class LazyExpressionCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        LazyExpression exp = (LazyExpression)expr;
        return compiler.compileToIterator(exp.getBaseExpression());
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        LazyExpression exp = (LazyExpression)expr;
        compiler.compilePush(exp.getBaseExpression());
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        LazyExpression exp = (LazyExpression)expr;
        return compiler.compileToItem(exp.getBaseExpression());
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction options) {
        LazyExpression exp = (LazyExpression)expr;
        return compiler.compileToEffectiveBooleanValue(exp.getBaseExpression(), options);
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        LazyExpression exp = (LazyExpression)expr;
        return compiler.compileToCharSequence(exp.getBaseExpression());
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, LoopAction action) {
        LazyExpression exp = (LazyExpression)expr;
        compiler.compileAsLoop(exp.getBaseExpression(), action);
    }

    public static String compileToEvaluableItem(CompilerService compiler, LazyExpression exp) {
        int n = compiler.getUniqueNumber();
        String itemVar = "lazy" + n;
        compiler.emit("EvaluableItem " + itemVar + " = new EvaluableItem() {");
        compiler.emit("public Item evaluateItem(final XPathContext context) throws XPathException {");
        compiler.pushContextVariable("context");
        String v = compiler.compileToItem(exp.getBaseExpression());
        compiler.popContextVariable();
        compiler.emit("return " + v + ";");
        compiler.emit("}");
        compiler.emit("};");
        String icVar = "lazy" + n + "ic";
        TypeHierarchy th = compiler.getTypeHierarchy();
        int primitiveType = exp.getBaseExpression().getItemType(th).getPrimitiveType();
        compiler.declare(ItemClosure.class, icVar, "new ItemClosure(" + itemVar + ", " + compiler.getContextVariableName() + ", " + primitiveType + ")", true);
        return icVar;
    }
}

