/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class KeyFnCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        String rootVar;
        KeyFn exp = (KeyFn)expr;
        StructuredQName kn = exp.getStaticKeyName();
        if (kn == null) {
            throw new UnsupportedOperationException("Can't compile code using dynamic calls on key()");
        }
        compiler.makeKeyDefinitionFunction(kn);
        int n = compiler.getUniqueNumber();
        String resultVar = "s" + n;
        if (exp.getNumberOfArguments() == 3) {
            rootVar = compiler.compileToItem(exp.getArguments()[2]);
        } else {
            rootVar = "root" + n;
            compiler.declare(NodeInfo.class, rootVar, "getContext(" + compiler.getContextItemVariableName() + ").getDocumentRoot()", true);
        }
        Expression actualValue = exp.getArguments()[1];
        if (Cardinality.allowsMany((int)actualValue.getCardinality())) {
            String masterVar = compiler.compileToIterator(actualValue);
            String cmf = "cmf" + n;
            compiler.emit("MappingFunction " + cmf + " = new MappingFunction() { // key() expression");
            compiler.emit("public SequenceIterator map(Item item) throws XPathException {");
            compiler.emit("return " + compiler.getContextVariableName() + ".getController().getKeyManager().selectByKey(" + compiler.compileStructuredQName(kn) + ", " + compiler.cast(rootVar, DocumentInfo.class) + ", " + compiler.cast("item", AtomicValue.class) + ", " + compiler.getContextVariableName() + ");");
            compiler.emit("}");
            compiler.emit("};");
            compiler.declare(SequenceIterator.class, resultVar, "new MappingIterator(" + masterVar + ", " + cmf + ")", true);
        } else {
            String masterVar = compiler.compileToItem(actualValue);
            compiler.declare(SequenceIterator.class, resultVar, compiler.getContextVariableName() + ".getController().getKeyManager().selectByKey(" + compiler.compileStructuredQName(kn) + ", " + compiler.cast(rootVar, DocumentInfo.class) + ", " + compiler.cast(masterVar, AtomicValue.class) + ", " + compiler.getContextVariableName() + ")", true);
        }
        return resultVar;
    }
}

