/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;

public class ItemCheckerCompiler
extends SequenceExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        ItemChecker exp = (ItemChecker)expr;
        ItemType requiredType = exp.getRequiredType();
        RoleLocator role = exp.getRoleLocator();
        String itemVar = compiler.compileToItem(exp.getBaseExpression());
        boolean allowEmpty = Cardinality.allowsZero((int)exp.getBaseExpression().getCardinality());
        this.compileErrorCheck(itemVar, requiredType, allowEmpty, compiler, role);
        return itemVar;
    }

    public String compileToIterator(CompilerService compiler, Expression expr) {
        ItemChecker exp = (ItemChecker)expr;
        ItemType requiredType = exp.getRequiredType();
        RoleLocator role = exp.getRoleLocator();
        String sequenceVar = compiler.compileToIterator(exp.getBaseExpression());
        int n = compiler.getUniqueNumber();
        String mf = "itemCheck" + n;
        String resultVar = "s" + n;
        compiler.emit("ItemMappingFunction " + mf + " = new ItemMappingFunction() { // check item type");
        compiler.emit("public Item mapItem(Item item) throws XPathException {");
        this.compileErrorCheck("item", requiredType, false, compiler, role);
        compiler.emit("return item;");
        compiler.emit("}");
        compiler.emit("};");
        compiler.emit("SequenceIterator " + resultVar + " = new EveryItemMappingIterator(" + sequenceVar + ", " + mf + ");");
        return resultVar;
    }

    private void compileErrorCheck(String itemVar, ItemType requiredType, boolean allowEmpty, CompilerService compiler, RoleLocator role) {
        String precondition;
        String typeVar = compiler.compileItemType(requiredType);
        String string = precondition = allowEmpty ? itemVar + "!=null && " : "";
        if (requiredType == AnyNodeTest.getInstance()) {
            compiler.emit("if (" + precondition + "!(" + itemVar + " instanceof NodeInfo)) {");
        } else if (requiredType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            compiler.emit("if (" + precondition + "!(" + itemVar + " instanceof AtomicValue)) {");
        } else if (requiredType.equals(BuiltInAtomicType.STRING)) {
            compiler.emit("if (" + precondition + "!(" + itemVar + " instanceof StringValue)) {");
        } else if (requiredType.equals(BuiltInAtomicType.NUMERIC)) {
            compiler.emit("if (" + precondition + "!(" + itemVar + " instanceof NumericValue)) {");
        } else if (requiredType.equals(BuiltInAtomicType.BOOLEAN)) {
            compiler.emit("if (" + precondition + "!(" + itemVar + " instanceof BooleanValue)) {");
        } else if (requiredType.equals(BuiltInAtomicType.ANY_URI)) {
            compiler.emit("if (" + precondition + "!(" + itemVar + " instanceof AnyURIValue)) {");
        } else {
            compiler.emit("if (" + precondition + "!" + typeVar + ".matchesItem(" + itemVar + ", true, config)) {");
        }
        compiler.emitDynamicError(role.composeRequiredMessage(requiredType, compiler.getNamePool()), role.getErrorCode());
        compiler.emit("}");
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        int loc = expr.getLocationId();
        ItemChecker exp = (ItemChecker)expr;
        ItemType requiredType = exp.getRequiredType();
        RoleLocator role = exp.getRoleLocator();
        if (Cardinality.allowsMany((int)exp.getCardinality())) {
            String iter = this.compileToIterator(compiler, (Expression)exp);
            String vbl = "it" + compiler.getUniqueNumber();
            compiler.emit("while (true) {");
            compiler.emit("Item " + vbl + " = " + iter + ".next();");
            compiler.emit("if (" + vbl + " == null) break;");
            this.compileErrorCheck(vbl, requiredType, false, compiler, role);
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + vbl + ", " + loc + ", NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        } else {
            String item = this.compileToItem(compiler, (Expression)exp);
            compiler.emit("if (" + item + " != null) {");
            this.compileErrorCheck(item, requiredType, false, compiler, role);
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + item + ", " + loc + ", NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        }
    }
}

