/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.IntegratedFunctionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class ItemAtCompiler
extends IntegratedFunctionCompiler {
    public String compile(CompilerService compiler, ExtensionFunctionCall expr, Expression[] arguments, String[] variables) {
        TypeHierarchy th = compiler.getTypeHierarchy();
        int n = compiler.getUniqueNumber();
        String baseVar = variables[0];
        Expression arg1 = arguments[1];
        if (arg1 instanceof Literal && ((Literal)arg1).getValue() instanceof IntegerValue) {
            long value;
            try {
                value = ((IntegerValue)((Literal)arg1).getValue()).longValue();
            }
            catch (XPathException err) {
                throw new AssertionError((Object)err);
            }
            String intVar = "" + value;
            String resultVar = "itemAt" + n;
            if (value <= 0L) {
                return "null";
            }
            String javaCode = "TailIterator.make(" + baseVar + ", " + "(int)" + intVar + ").next()";
            compiler.declare(Item.class, resultVar, javaCode, true);
            return resultVar;
        }
        String indexVar = variables[1];
        indexVar = compiler.cast(indexVar, NumericValue.class);
        boolean indexIsInteger = th.isSubType(arg1.getItemType(th), (ItemType)BuiltInAtomicType.INTEGER);
        String intVar = indexIsInteger ? indexVar + ".longValue()" : "(" + indexVar + ".isWholeNumber() ? " + indexVar + ".longValue() : 0 )";
        boolean indexExists = !Cardinality.allowsZero((int)arg1.getCardinality());
        String resultVar = "itemAt" + n;
        String javaCode = "(" + intVar + "<=0 ? null : TailIterator.make(" + baseVar + ", " + "(int)" + intVar + ").next())";
        if (!indexExists) {
            javaCode = "(" + indexVar + "==null ? null : " + javaCode + ")";
        }
        compiler.declare(Item.class, resultVar, javaCode, true);
        return resultVar;
    }
}

