/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.IntegratedFunctionCompiler;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.IntegratedFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class IntegratedFunctionCallCompiler
extends ExpressionCompiler {
    private String compile(CompilerService compiler, Expression expr) {
        IntegratedFunctionCall exp = (IntegratedFunctionCall)expr;
        Expression[] args = exp.getArguments();
        String[] variableNames = new String[args.length];
        ExtensionFunctionCall fn = exp.getFunction();
        ExtensionFunctionDefinition def = fn.getDefinition();
        for (int i = 0; i < args.length; ++i) {
            SequenceType st = def.getArgumentTypes()[i];
            variableNames[i] = Cardinality.allowsMany((int)st.getCardinality()) ? compiler.compileToIterator(args[i]) : compiler.compileToItem(args[i]);
        }
        IntegratedFunctionCompiler comp = (IntegratedFunctionCompiler)def.getCompilerForJava();
        if (comp == null) {
            throw new UnsupportedOperationException("No code generator available for integrated extension function " + def.getFunctionQName().getClarkName());
        }
        return comp.compile(compiler, exp.getFunction(), exp.getArguments(), variableNames);
    }

    public void compilePush(CompilerService compiler, Expression expression) {
        String value = this.compile(compiler, expression);
        int loc = expression.getLocationId();
        if (this.hasBooleanResult(compiler, expression)) {
            compiler.emit(compiler.getOutputterVariableName() + ".append(BooleanValue.get(" + value + "), " + loc + ", NodeInfo.ALL_NAMESPACES);");
        } else if (this.hasItemResult(expression)) {
            compiler.emit("if (" + value + " != null) {");
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + value + ", " + loc + ", NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        } else {
            String vbl = "it" + compiler.getUniqueNumber();
            compiler.emit("while (true) {");
            compiler.declare(Item.class, vbl, value + ".next();", true);
            compiler.emit("if (" + vbl + " == null) break;");
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + vbl + ", " + loc + ", NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        }
    }

    public String compileToItem(CompilerService compiler, Expression expression) {
        String value = this.compile(compiler, expression);
        if (this.hasBooleanResult(compiler, expression)) {
            return "BooleanValue.get(" + value + ")";
        }
        if (this.hasItemResult(expression)) {
            return value;
        }
        throw new UnsupportedOperationException("compileToItem on non-singleton");
    }

    public String compileToIterator(CompilerService compiler, Expression expression) {
        String value = this.compile(compiler, expression);
        if (this.hasBooleanResult(compiler, expression)) {
            return "SingletonIterator.makeIterator(BooleanValue.get(" + value + "))";
        }
        if (this.hasItemResult(expression)) {
            return "SingletonIterator.makeIterator(" + value + ")";
        }
        return value;
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expression, ReturnAction options) {
        String value = this.compile(compiler, expression);
        if (this.hasBooleanResult(compiler, expression)) {
            return value;
        }
        if (this.hasItemResult(expression)) {
            return "ExpressionTool.effectiveBooleanValue(SingletonIterator.makeIterator(" + value + "))";
        }
        return "ExpressionTool.effectiveBooleanValue(" + value + ")";
    }

    private boolean hasBooleanResult(CompilerService compiler, Expression expr) {
        return !Cardinality.allowsMany((int)expr.getCardinality()) && !Cardinality.allowsZero((int)expr.getCardinality()) && expr.getItemType(compiler.getTypeHierarchy()) == BuiltInAtomicType.BOOLEAN;
    }

    private boolean hasItemResult(Expression expr) {
        return !Cardinality.allowsMany((int)expr.getCardinality());
    }
}

