/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.Value;

public class IntegerRangeCompiler
extends ValueCompiler {
    public String compileToIterator(CompilerService compiler, Value expr) {
        IntegerRange exp = (IntegerRange)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = "range" + n;
        compiler.emit("RangeIterator " + resultVar + " = new RangeIterator(" + exp.getStart() + ", " + exp.getEnd() + ");");
        return resultVar;
    }

    public void compileAsLoop(CompilerService compiler, Value expr, LoopAction action) {
        IntegerRange exp = (IntegerRange)expr;
        int n = compiler.getUniqueNumber();
        String intVar = "i" + n;
        String boxedVar = "ival" + n;
        compiler.emit("for (int " + intVar + "=" + exp.getStart() + "; " + intVar + "<=" + exp.getEnd() + "; " + intVar + "++) {");
        compiler.declare(Int64Value.class, boxedVar, "Int64Value.makeIntegerValue(" + intVar + ")", true);
        action.compileAction(compiler, boxedVar);
        compiler.emit("}");
    }

    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        return null;
    }
}

