/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaAssignment;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;

public class InstanceOfCompiler
extends ToBooleanCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        int n = compiler.getUniqueNumber();
        InstanceOfExpression exp = (InstanceOfExpression)expr;
        final ItemType itemType = exp.getRequiredItemType();
        int cardinality = exp.getRequiredCardinality();
        final boolean disallowsMany = !Cardinality.allowsMany((int)cardinality);
        final boolean disallowsZero = !Cardinality.allowsZero((int)cardinality);
        final String itemTypeVar = compiler.compileItemType(itemType);
        ReturnAction newRA = result;
        String resultBooleanVar = result.getVariableName();
        if (result instanceof JavaDeclaration) {
            newRA = new JavaAssignment(Boolean.TYPE, result.getVariableName());
            compiler.declare(Boolean.TYPE, result.getVariableName(), "true", false);
        } else if (result instanceof JavaAssignment) {
            compiler.emit(resultBooleanVar + " = true;");
        }
        final ReturnAction result2 = newRA;
        int baseCardinality = exp.getBaseExpression().getCardinality();
        if (baseCardinality == 16384) {
            String itemVar = compiler.compileToItem(exp.getBaseExpression());
            compiler.emit(newRA.output(compiler, this.getTestExpression(itemVar, itemType, itemTypeVar)));
        } else if (Cardinality.allowsMany((int)baseCardinality)) {
            final String countVar = "count" + n;
            if (disallowsMany || disallowsZero) {
                compiler.emit("int " + countVar + " = 0;");
            }
            LoopAction innerLoop = new LoopAction(){

                public void compileAction(CompilerService compiler, String itemVar) {
                    String test = InstanceOfCompiler.this.getTestExpression(itemVar, itemType, itemTypeVar);
                    compiler.emit("if (!" + test + ") {");
                    compiler.emit(result2.output(compiler, "false"));
                    compiler.emit("break;");
                    compiler.emit("}");
                    if (disallowsZero || disallowsMany) {
                        compiler.emit(countVar + "++;");
                    }
                    if (disallowsMany) {
                        compiler.emit("if (" + countVar + " == 2) {");
                        compiler.emit(result2.output(compiler, "false"));
                        compiler.emit("break;");
                        compiler.emit("}");
                    }
                }
            };
            compiler.compileAsLoop(exp.getBaseExpression(), innerLoop);
            String resultExp = resultBooleanVar;
            if (disallowsZero) {
                resultExp = resultExp + " && (" + countVar + " != 0)";
            }
            compiler.emit(result2.output(compiler, resultExp));
        } else {
            String itemVar = compiler.compileToItem(exp.getBaseExpression());
            if (disallowsZero) {
                String calc = "(" + itemVar + "==null ? false : " + this.getTestExpression(itemVar, itemType, itemTypeVar) + ")";
                compiler.emit(result2.output(compiler, calc));
            }
        }
        return result.getVariableName();
    }

    private String getTestExpression(String itemVar, ItemType itemType, String itemTypeVar) {
        if (itemType == AnyNodeTest.getInstance()) {
            return "(" + itemVar + " instanceof NodeInfo)";
        }
        if (itemType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            return "(" + itemVar + " instanceof AtomicValue)";
        }
        return itemTypeVar + ".matchesItem(" + itemVar + ", false, config)";
    }
}

