/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import com.saxonica.codegen.VariableReferenceCompiler;
import com.saxonica.expr.IndexedFilterExpression;
import com.saxonica.expr.IndexedValue;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;

public class IndexedFilterExpressionCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        IndexedFilterExpression exp = (IndexedFilterExpression)expr;
        ComparisonExpression filter = exp.getFilter();
        VariableReference var = exp.getBaseExpression();
        String baseVar = VariableReferenceCompiler.getJavaVariableName(compiler, var);
        int n = compiler.getUniqueNumber();
        String useVar = "use" + n;
        compiler.emitInstanceVariable(SequenceIterable.class, useVar, "null", 3, false, false, null, null);
        String contextVar = compiler.getContextVariableName();
        Expression useExp = exp.getUseExpression();
        compiler.emit("if (" + useVar + " == null) " + useVar + " = new SequenceIterable() {");
        compiler.emit("public SequenceIterator iterate(final XPathContext context) throws XPathException {");
        compiler.pushContextVariable("context");
        String itemVar = "item" + n;
        compiler.declare(Item.class, itemVar, "context.getContextItem()", true);
        compiler.pushContextItemVariable(itemVar);
        String s = compiler.compileToIterator(useExp);
        compiler.emit("return " + s + ";");
        compiler.popContextItemVariable();
        compiler.popContextVariable();
        compiler.emit("}");
        compiler.emit("};");
        Expression searchExp = exp.getSearchExpression();
        String searchVar = compiler.compileToIterator(searchExp);
        boolean convertUntypedToOther = filter.convertsUntypedToOther();
        String resultVar = "s" + n;
        compiler.declare(SequenceIterator.class, resultVar, compiler.cast(baseVar, IndexedValue.class) + ".findItems(" + useVar + ", " + searchVar + ", " + convertUntypedToOther + ", false, " + compiler.compileAtomicComparer(filter.getAtomicComparer()) + ", " + contextVar + ")", true);
        return resultVar;
    }
}

