/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.InScopePrefixes;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.StringValue;

public class InScopePrefixesCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        InScopePrefixes exp = (InScopePrefixes)expr;
        int n = compiler.getUniqueNumber();
        String resolverVar = "resolver" + n;
        String listVar = "nslist" + n;
        String iterVar = "iter" + n;
        String prefixVar = "prefix" + n;
        String resultVar = "prefixIter" + n;
        String elementVar = compiler.compileToItem(exp.getArguments()[0]);
        compiler.declare(NamespaceResolver.class, resolverVar, "new InscopeNamespaceResolver(" + compiler.cast(elementVar, NodeInfo.class) + ")", true);
        compiler.declare(List.class, listVar, "new ArrayList(10)", true);
        compiler.declare(Iterator.class, iterVar, resolverVar + ".iteratePrefixes()", true);
        compiler.emit("while (" + iterVar + ".hasNext()) {");
        compiler.declare(String.class, prefixVar, "(String)" + iterVar + ".next()", true);
        compiler.emit(listVar + ".add(" + prefixVar + ".equals(\"\") ? StringValue.EMPTY_STRING : " + "StringValue.makeRestrictedString(" + prefixVar + ", BuiltInAtomicType.NCNAME, null));");
        compiler.emit("}");
        compiler.declare(SequenceIterator.class, resultVar, "new net.sf.saxon.tree.iter.ListIterator(" + listVar + ")", true);
        return resultVar;
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, LoopAction action) {
        InScopePrefixes exp = (InScopePrefixes)expr;
        int n = compiler.getUniqueNumber();
        String resolverVar = "resolver" + n;
        String listVar = "nslist" + n;
        String iterVar = "iter" + n;
        String prefixVar = "prefix" + n;
        String elementVar = compiler.compileToItem(exp.getArguments()[0]);
        compiler.declare(NamespaceResolver.class, resolverVar, "new InscopeNamespaceResolver(" + compiler.cast(elementVar, NodeInfo.class) + ")", true);
        compiler.declare(List.class, listVar, "new ArrayList(10)", true);
        compiler.declare(Iterator.class, iterVar, resolverVar + ".iteratePrefixes()", true);
        compiler.emit("while (" + iterVar + ".hasNext()) {");
        compiler.declare(StringValue.class, prefixVar, "new StringValue((String)" + iterVar + ".next())", true);
        action.compileAction(compiler, prefixVar);
        compiler.emit("}");
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        InScopePrefixes exp = (InScopePrefixes)expr;
        int n = compiler.getUniqueNumber();
        String resolverVar = "resolver" + n;
        String iterVar = "iter" + n;
        String prefixVar = "prefix" + n;
        String elementVar = compiler.compileToItem(exp.getArguments()[0]);
        compiler.declare(NamespaceResolver.class, resolverVar, "new InscopeNamespaceResolver(" + compiler.cast(elementVar, NodeInfo.class) + ")", true);
        compiler.declare(Iterator.class, iterVar, resolverVar + ".iteratePrefixes()", true);
        compiler.emit("while (" + iterVar + ".hasNext()) {");
        compiler.declare(String.class, prefixVar, "(String)" + iterVar + ".next()", true);
        compiler.emit(compiler.getOutputterVariableName() + ".append(new StringValue(" + prefixVar + "), 0, 0);");
        compiler.emit("}");
    }
}

