/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.IdCompiler;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.Idref;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class IdrefCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        Idref exp = (Idref)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = "idref" + n;
        String rootVar = IdCompiler.compileRootArgument(n, (SystemFunction)exp, compiler);
        Expression actualValue = exp.getArguments()[0];
        if (Cardinality.allowsMany((int)actualValue.getCardinality())) {
            String masterVar = compiler.compileToIterator(actualValue);
            compiler.declare(SequenceIterator.class, resultVar, "Idref.getIdrefMultiple(" + rootVar + ", " + masterVar + ", " + compiler.getContextVariableName() + ")", true);
        } else {
            String idrefsVar = compiler.compileToItem(actualValue);
            String jexp = compiler.getContextVariableName() + ".getController().getKeyManager().selectByKey(" + "StandardNames.getStructuredQName(StandardNames.XS_IDREFS), " + rootVar + ", " + compiler.cast(idrefsVar, AtomicValue.class) + ", " + compiler.getContextVariableName() + ")";
            if (Cardinality.allowsZero((int)actualValue.getCardinality())) {
                jexp = "(" + idrefsVar + " == null ? EmptyIterator.getInstance() : " + jexp + ")";
            }
            compiler.declare(SequenceIterator.class, resultVar, jexp, true);
        }
        return resultVar;
    }
}

