/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.Id;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class IdCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        Id exp = (Id)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = "id" + n;
        String rootVar = IdCompiler.compileRootArgument(n, (SystemFunction)exp, compiler);
        int op = exp.getDetails().opcode;
        Expression actualValue = exp.getArguments()[0];
        if (Cardinality.allowsMany((int)actualValue.getCardinality())) {
            String masterVar = compiler.compileToIterator(actualValue);
            compiler.declare(SequenceIterator.class, resultVar, "Id.getIdMultiple(" + rootVar + ", " + masterVar + ", " + op + ")", true);
        } else {
            String idrefsVar = compiler.compileToItem(actualValue);
            String jexp = "Id.getIdSingle(" + rootVar + ", " + idrefsVar + ".getStringValue(), " + op + ")";
            if (Cardinality.allowsZero((int)actualValue.getCardinality())) {
                jexp = "(" + idrefsVar + " == null ? EmptyIterator.getInstance() : " + jexp + ")";
            }
            compiler.declare(SequenceIterator.class, resultVar, jexp, true);
        }
        return resultVar;
    }

    public static String compileRootArgument(int n, SystemFunction exp, CompilerService compiler) {
        String rootJExp;
        String rootVar = "root" + n;
        boolean checkRootless = true;
        if (exp.getNumberOfArguments() == 2) {
            Expression arg1 = exp.getArguments()[1];
            rootJExp = compiler.compileToItem(arg1);
            TypeHierarchy th = compiler.getTypeHierarchy();
            if (th.isSubType(arg1.getItemType(th), (ItemType)NodeKindTest.DOCUMENT)) {
                rootJExp = compiler.cast(rootJExp, DocumentInfo.class);
                checkRootless = false;
            } else {
                rootJExp = compiler.cast(rootJExp, NodeInfo.class) + ".getDocumentRoot()";
            }
        } else {
            rootJExp = "getContext(" + compiler.getContextItemVariableName() + ").getDocumentRoot()";
        }
        compiler.declare(DocumentInfo.class, rootVar, rootJExp, true);
        if (checkRootless) {
            compiler.emit("if (" + rootVar + " == null) {");
            compiler.emitDynamicError("The " + (exp.getNumberOfArguments() == 2 ? "second argument" : "context item") + " for " + exp.getDisplayName() + "() must be a node in a tree whose root is a document node", "FODC0001");
            compiler.emit("}");
        }
        return rootVar;
    }
}

