/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaAssignment;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.Token;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class GeneralComparisonCompiler
extends ToBooleanCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        GeneralComparison exp = (GeneralComparison)expr;
        Expression[] operands = exp.getOperands();
        int operator = exp.getOperator();
        int c0 = operands[0].getCardinality();
        int c1 = operands[1].getCardinality();
        String compVar = compiler.compileAtomicComparer(exp.getAtomicComparer());
        if (!Cardinality.allowsMany((int)c1)) {
            return this.compileManyToOne(compiler, operands[0], operands[1], result, c1, operator, compVar);
        }
        if (!Cardinality.allowsMany((int)c0)) {
            return this.compileManyToOne(compiler, operands[1], operands[0], result, c0, Token.inverse((int)operator), compVar);
        }
        int n = compiler.getUniqueNumber();
        String op0var = compiler.compileToIterator(operands[0]);
        String op1var = compiler.compileToIterator(operands[1]);
        compiler.emit("SimpleAtomicComparer comp" + n + " =  new SimpleAtomicComparer() {");
        compiler.emit("public boolean compare(AtomicValue v0, AtomicValue v1) {");
        compiler.emit("try{");
        compiler.emit("if (false) throw new net.sf.saxon.trans.NoDynamicContextException(\"\");");
        compiler.emit("return " + this.comparisonExpression(compiler, operator, compVar, "v0", "v1") + ";");
        compiler.emit("} catch (net.sf.saxon.trans.NoDynamicContextException e) {throw new AssertionError(e);}");
        compiler.emit("}");
        compiler.emit("};");
        compiler.emit(result.output(compiler, "generalCompare(" + op0var + ", " + op1var + ", comp" + n + ", " + compiler.getContextVariableName() + ")"));
        return result.getVariableName();
    }

    private String compileManyToOne(CompilerService compiler, Expression opMany, Expression opOne, ReturnAction result, int cardOne, int operator, String compVar) {
        String guard;
        String opManyVar = compiler.compileToIterator(opMany);
        String opOneVar = compiler.compileToItem(opOne);
        TypeHierarchy th = compiler.getTypeHierarchy();
        boolean oneMayBeUntyped = th.relationship(opOne.getItemType(th), (ItemType)BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
        boolean manyMayBeUntyped = th.relationship(opMany.getItemType(th), (ItemType)BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
        int n = compiler.getUniqueNumber();
        String opLoopItemVar = "item" + n;
        if (result instanceof JavaDeclaration) {
            compiler.declare(Boolean.TYPE, result.getVariableName(), "false", false);
            result = new JavaAssignment(Boolean.TYPE, result.getVariableName());
        }
        boolean conditional = false;
        if (Cardinality.allowsZero((int)cardOne)) {
            compiler.emit("if (" + opOneVar + " == null) {");
            compiler.emit(result.output(compiler, "false"));
            compiler.emit("} else {");
            conditional = true;
        }
        compiler.emit(result.output(compiler, "false"));
        compiler.emit("while (true) {");
        compiler.declare(AtomicValue.class, opLoopItemVar, compiler.cast(opManyVar + ".next()", AtomicValue.class), true);
        compiler.emit("if (" + opLoopItemVar + " == null) break;");
        String opOneVarConverted = opOneVar;
        String opLoopItemVarConverted = opLoopItemVar;
        if (oneMayBeUntyped) {
            guard = "";
            if (manyMayBeUntyped) {
                guard = " && !(" + opLoopItemVar + " instanceof UntypedAtomicValue)";
            }
            opOneVarConverted = opOneVarConverted + "conv";
            compiler.declare(AtomicValue.class, opOneVarConverted, compiler.cast(opOneVar, AtomicValue.class), false);
            compiler.emit("if ((" + opOneVar + " instanceof UntypedAtomicValue) " + guard + ") {");
            compiler.assign(opOneVarConverted, compiler.cast(opOneVar, AtomicValue.class) + ".convert(" + compiler.cast(opLoopItemVar, AtomicValue.class) + ".getPrimitiveType(), " + compiler.getContextVariableName() + ")");
            compiler.emit("}");
        }
        if (manyMayBeUntyped) {
            guard = "";
            if (oneMayBeUntyped) {
                guard = " && !(" + opOneVar + " instanceof UntypedAtomicValue)";
            }
            opLoopItemVarConverted = opLoopItemVarConverted + "conv";
            compiler.declare(AtomicValue.class, opLoopItemVarConverted, compiler.cast(opLoopItemVar, AtomicValue.class), false);
            compiler.emit("if ((" + opLoopItemVar + " instanceof UntypedAtomicValue) " + guard + ") {");
            compiler.assign(opLoopItemVarConverted, compiler.cast(opLoopItemVar, AtomicValue.class) + ".convert(" + compiler.cast(opOneVar, AtomicValue.class) + ".getPrimitiveType(), " + compiler.getContextVariableName() + ")");
            compiler.emit("}");
        }
        compiler.emit("if (" + this.comparisonExpression(compiler, operator, compVar, opLoopItemVarConverted, opOneVarConverted) + ") {");
        compiler.emit(result.output(compiler, "true"));
        compiler.emit("break;");
        compiler.emit("}");
        compiler.emit("}");
        if (conditional) {
            compiler.emit("}");
        }
        return result.getVariableName();
    }

    private String comparisonExpression(CompilerService compiler, int operator, String compVar, String v0, String v1) {
        v0 = compiler.cast(v0, AtomicValue.class);
        v1 = compiler.cast(v1, AtomicValue.class);
        switch (operator) {
            case 6: {
                return compVar + ".comparesEqual(" + v0 + ", " + v1 + ")";
            }
            case 22: {
                return "!" + compVar + ".comparesEqual(" + v0 + ", " + v1 + ")";
            }
            case 11: {
                return compVar + ".compareAtomicValues(" + v0 + ", " + v1 + ") > 0";
            }
            case 12: {
                return compVar + ".compareAtomicValues(" + v0 + ", " + v1 + ") < 0";
            }
            case 13: {
                return compVar + ".compareAtomicValues(" + v0 + ", " + v1 + ") >= 0";
            }
            case 14: {
                return compVar + ".compareAtomicValues(" + v0 + ", " + v1 + ") <= 0";
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + operator);
    }
}

