/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import com.saxonica.expr.JavaExtensionFunctionCall;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.saxon.expr.CodeGeneratorService;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Value;

public class ExtensionFunctionCallCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        String iterExp;
        JavaExtensionFunctionCall exp = (JavaExtensionFunctionCall)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = this.compileRawCall(exp, n, compiler);
        String iterResult = "resultIterator" + n;
        if (Value.class.isAssignableFrom(exp.getReturnClass())) {
            iterExp = resultVar + ".iterate()";
        } else if (ValueRepresentation.class.isAssignableFrom(exp.getReturnClass())) {
            iterExp = "Value.asIterator(" + resultVar + ")";
        } else {
            if (SequenceIterator.class.isAssignableFrom(exp.getReturnClass())) {
                return resultVar;
            }
            JPConverter jp = exp.getResultConverter();
            iterExp = "Value.asIterator(" + jp.compile(resultVar, (CodeGeneratorService)compiler) + ")";
        }
        compiler.declare(SequenceIterator.class, iterResult, iterExp, true);
        return iterResult;
    }

    private String compileRawCall(JavaExtensionFunctionCall exp, int n, CompilerService compiler) {
        Expression[] arguments = exp.getArguments();
        String[] argVars = new String[arguments.length];
        String resultVar = "extResult" + n;
        for (int i = 0; i < arguments.length; ++i) {
            argVars[i] = compiler.compileToValueRepresentation(arguments[i]);
        }
        FastStringBuffer call = new FastStringBuffer(64);
        AccessibleObject theMethod = exp.getTargetMethod();
        if (theMethod instanceof Constructor) {
            call.append("new ");
            call.append(exp.getTargetClass().getName());
            call.append('(');
            for (int i = 0; i < arguments.length; ++i) {
                call.append(this.processArgument(compiler, argVars[i], ((Constructor)theMethod).getParameterTypes()[i], exp.getArgumentConverters()[i]));
                if (i == arguments.length - 1) continue;
                call.append(", ");
            }
            call.append(')');
        } else if (theMethod instanceof Method) {
            int firstArg;
            boolean usesContext;
            boolean isStatic = Modifier.isStatic(((Method)theMethod).getModifiers());
            Class<?>[] theParameterTypes = ((Method)theMethod).getParameterTypes();
            boolean bl = usesContext = theParameterTypes.length > 0 && theParameterTypes[0] == XPathContext.class;
            if (isStatic) {
                call.append(exp.getTargetClass().getName());
                firstArg = 0;
            } else {
                call.append(this.processArgument(compiler, argVars[0], exp.getTargetClass(), exp.getArgumentConverters()[0]));
                firstArg = 1;
            }
            call.append('.');
            call.append(((Method)theMethod).getName());
            call.append('(');
            if (usesContext) {
                call.append(compiler.getContextVariableName());
                if (arguments.length > 0) {
                    call.append(", ");
                }
            }
            for (int i = firstArg; i < arguments.length; ++i) {
                call.append(this.processArgument(compiler, argVars[i], ((Method)theMethod).getParameterTypes()[i - firstArg], exp.getArgumentConverters()[i]));
                if (i == arguments.length - 1) continue;
                call.append(", ");
            }
            call.append(')');
        } else if (theMethod instanceof Field) {
            boolean isStatic = Modifier.isStatic(((Field)theMethod).getModifiers());
            if (isStatic) {
                call.append(exp.getTargetClass().getName());
            } else {
                call.append(argVars[0]);
            }
            call.append('.');
            call.append(((Field)theMethod).getName());
        }
        compiler.declare(exp.getReturnClass(), resultVar, null, false);
        compiler.emit("try {");
        compiler.assign(resultVar, call.toString());
        compiler.emit("} catch (Exception e) {");
        compiler.emit("throw new XPathException(e);");
        compiler.emit("}");
        return resultVar;
    }

    private String processArgument(CompilerService compiler, String argVar, Class targetClass, PJConverter pj) {
        return pj.compile(argVar, targetClass, (CodeGeneratorService)compiler);
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        JavaExtensionFunctionCall exp = (JavaExtensionFunctionCall)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = this.compileRawCall(exp, n, compiler);
        if (Item.class.isAssignableFrom(exp.getReturnClass())) {
            return resultVar;
        }
        String itemResult = "resultItem" + n;
        JPConverter jp = exp.getResultConverter();
        String itemExp = "Value.asItem(" + jp.compile(resultVar, (CodeGeneratorService)compiler) + ")";
        compiler.declare(Item.class, itemResult, itemExp, true);
        return itemResult;
    }
}

