/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerClassMapper;
import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LiteralCompiler;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import com.saxonica.deploy.CompiledMemoClosure;
import com.saxonica.functions.hof.UserFunctionItem;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SingletonItem;
import net.sf.saxon.value.Value;

public abstract class ExpressionCompiler {
    private Configuration config;

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public abstract void compilePush(CompilerService var1, Expression var2);

    public abstract String compileToItem(CompilerService var1, Expression var2);

    public abstract String compileToIterator(CompilerService var1, Expression var2);

    public abstract String compileToEffectiveBooleanValue(CompilerService var1, Expression var2, ReturnAction var3);

    public String compileToCharSequence(CompilerService compiler, Expression expression) {
        String item = this.compileToItem(compiler, expression);
        return "(" + item + " == null ? \"\" : " + item + ".getStringValueCS())";
    }

    public String compileToValueRepresentation(CompilerService compiler, Expression expression) {
        if (Cardinality.allowsMany((int)expression.getCardinality())) {
            String iterVar = compiler.compileToIterator(expression);
            int n = compiler.getUniqueNumber();
            String jexp = "new CompiledMemoClosure(" + iterVar + ", " + expression.getItemType(compiler.getTypeHierarchy()).getPrimitiveType() + ", " + expression.getCardinality() + ")";
            String var = "val" + n;
            compiler.declare(CompiledMemoClosure.class, var, jexp, true);
            return var;
        }
        return this.compileToItem(compiler, expression);
    }

    public void compileAsLoop(CompilerService compiler, Expression expression, LoopAction action) {
        int n = compiler.getUniqueNumber();
        if (expression.getCardinality() == 16384) {
            String itemVar = compiler.compileToItem(expression);
            compiler.emit("while (true) { // once only");
            action.compileAction(compiler, itemVar);
            compiler.emit("break;");
            compiler.emit("}");
        } else if (Cardinality.allowsMany((int)expression.getCardinality())) {
            String iterVar = compiler.compileToIterator(expression);
            String itemVar = "item" + n;
            compiler.emit("while (true) {");
            compiler.declare(Item.class, itemVar, iterVar + ".next()", true);
            compiler.emit("if (" + itemVar + " == null) break;");
            action.compileAction(compiler, itemVar);
            compiler.emit("}");
        } else {
            String itemVar = compiler.compileToItem(expression);
            compiler.emit("while (" + itemVar + " != null) { // at most once");
            action.compileAction(compiler, itemVar);
            compiler.emit("break;");
            compiler.emit("}");
        }
    }

    public static ExpressionCompiler makeExpressionCompiler(Expression exp, Configuration config) {
        ExpressionCompiler ec;
        if (exp instanceof Literal) {
            Value value = ((Literal)exp).getValue();
            if (value instanceof SingletonItem && ((SingletonItem)value).getItem() instanceof UserFunctionItem) {
                throw new UnsupportedOperationException("Code using higher-order functions cannot be compiled");
            }
            ValueCompiler avc = CompilerClassMapper.map(value);
            if (avc == null) {
                throw new UnsupportedOperationException("No compiler exists for items of class " + value.getClass().getName());
            }
            ec = new LiteralCompiler(avc);
        } else {
            ec = CompilerClassMapper.map(exp);
        }
        if (ec == null) {
            throw new UnsupportedOperationException("No compiler exists for class " + exp.getClass().getName());
        }
        ec.setConfiguration(config);
        return ec;
    }
}

