/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DurationValue;

public class DurationValueCompiler
extends ValueCompiler {
    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        DurationValue dt;
        AtomicType type = value.getTypeLabel();
        String t = "";
        if (!type.equals(BuiltInAtomicType.DURATION)) {
            t = ", " + compiler.compileItemType((ItemType)type);
        }
        boolean positive = (dt = (DurationValue)value).signum() >= 0;
        int years = dt.getYears();
        int months = dt.getMonths();
        int days = dt.getDays();
        int hours = dt.getHours();
        int minutes = dt.getMinutes();
        int seconds = dt.getSeconds();
        int microseconds = dt.getMicroseconds();
        return "new DurationValue(" + positive + ", " + years + ", " + months + ", " + days + ", " + hours + ", " + minutes + ", " + seconds + ", " + microseconds + t + ")";
    }
}

