/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Value;

public class DoubleValueCompiler
extends ValueCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Value expr, ReturnAction result) {
        compiler.emit(result.output(compiler, ((DoubleValue)expr).isNaN() || ((DoubleValue)expr).compareTo(0L) == 0 ? "false" : "true"));
        return result.getVariableName();
    }

    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        DoubleValue dv = (DoubleValue)value;
        double d = dv.getDoubleValue();
        AtomicType type = dv.getTypeLabel();
        if (type.equals(BuiltInAtomicType.DOUBLE)) {
            if (Double.isNaN(d)) {
                return "DoubleValue.NaN";
            }
            if (d == 0.0) {
                if (Double.doubleToLongBits(d) < 0L) {
                    return "DoubleValue.NEGATIVE_ZERO";
                }
                return "DoubleValue.ZERO";
            }
            if (d == 1.0) {
                return "DoubleValue.ONE";
            }
            if (Double.isInfinite(d)) {
                if (d > 0.0) {
                    return "new DoubleValue(Double.POSITIVE_INFINITY)";
                }
                return "new DoubleValue(Double.NEGATIVE_INFINITY)";
            }
            return "new DoubleValue(" + Double.toString(d) + ")";
        }
        String t = compiler.compileItemType((ItemType)type);
        if (Double.isNaN(d)) {
            return "new DoubleValue(Double.NaN, " + t + ")";
        }
        if (Double.isInfinite(d)) {
            if (d > 0.0) {
                return "new DoubleValue(Double.POSITIVE_INFINITY, " + t + ")";
            }
            return "new DoubleValue(Double.NEGATIVE_INFINITY, " + t + ")";
        }
        return "new DoubleValue(" + Double.toString(d) + ", " + t + ")";
    }
}

